import React from 'react';
import { makeStyles } from '@material-ui/core/styles';
import Dialogs from "@/commons/components/Dialog/Dialogs";
import { Typography } from "@material-ui/core";
import { CopyToClipboard } from 'react-copy-to-clipboard';
import FileCopyOutlinedIcon from '@material-ui/icons/FileCopyOutlined';
import Public from "@/commons/components/Public";
import { CLOUDE } from "@/commons/utils/constants";
import { Grid } from "@material-ui/core";
import Text from "@/commons/components/Material.Ui/Text"
const useStyles = makeStyles({
    classNameType:{ maxWidth:'inherit' }
})
export default props => {
    const { open, password, closeDialogCallBack, system } = props;
    const classes = useStyles()
    const { setMessages, render } = Public()
    return render(
        <Dialogs
            dialogs={open}
            type="2"
            classes={classes}
            isBotton={false}
            btnMarginTop="20px"
            mixWidth="28rem"
            height="11.125rem"
            classNameType = {'classNameType'}
            isBottom={true}
            style={{ flex: 1 }}
            closeAccountDialog={() => closeDialogCallBack()}
        >
            <Grid style={{ margin: "0 auto", padding: "46px 0 60px", boxSizing: "border-box", alignItems: 'center' }}>
                <Grid style={{ display: "flex", }} >
                    <Text variant={"body1"} text={CLOUDE['userName'] + "：" + (system === "LINUX" ? "cloudam" : "Administrator")} />
                    <CopyToClipboard text={system === "LINUX" ? "cloudam" : "Administrator"}
                        onCopy={() => {
                            setMessages({
                                message: CLOUDE['copySuccess'],
                                messagetype: 'success',
                            })
                        }}>
                        <FileCopyOutlinedIcon fontSize={'small'} style={{ color: "#136EFA", marginLeft: "10px", cursor: "pointer" }} />
                    </CopyToClipboard>
                </Grid>
                <Grid style={{ display: "flex", }} >
                    <Grid style={{ textAlign: 'center', display: "flex", alignItems: "center" }}>
                        <Text variant={"body1"} text={CLOUDE['password'] + "："} />
                        <Text variant={"body1"} text={password} />
                    </Grid>
                    <CopyToClipboard text={`${password}`}
                        onCopy={() => {
                            setMessages({
                                message: CLOUDE['copySuccess'],
                                messagetype: 'success',
                            })
                        }}>
                        <FileCopyOutlinedIcon fontSize={'small'} style={{ color: "#136EFA", marginLeft: "10px", cursor: "pointer" }} />
                    </CopyToClipboard>
                </Grid>
            </Grid>
        </Dialogs>
    )
}