/*
 * @Author: 吴永生#A02208 yongsheng.wu@wholion.com
 * @Date: 2022-06-13 17:00:19
 * @LastEditors: 吴永生 15770852798@163.com
 * @LastEditTime: 2022-09-01 19:34:46
 * @FilePath: /bkunyun/src/store/modules/upload.ts
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */

import {  makeAutoObservable } from "mobx";

export interface IUploadInfo {
  id: string,
  file: File,
  info: any,
  path: string;
}

/** 存储地图派单websocket推送数据状态的store  */
class FileList {
  constructor() {
    makeAutoObservable(this);
  }
  
  /** 文件上传列表 */
  fileList: IUploadInfo[] = [];
  
  /** 是否打开传输列表 */
  openFileList: boolean = false

  // setFileList (val: IUploadInfo[]) {
  //   this.fileList = val
  // }

  /** 新需要上传的文件列表 */
  newFileList: IUploadInfo[] = [];

  /** 设置最新需要上传的文件列表 */
  setNewFileList = (val: IUploadInfo[]) => {
    this.fileList = this.fileList.concat(val)
    this.newFileList = val
  }

  /** 打开关闭文件列表 */
  setOpenFileList = (val: boolean) => {
    this.openFileList = val
  }

  /** 设置文件上传信息 */
  setUploadInfo = (id: string, val: IUploadInfo) => {
    const newFileList = this.fileList?.map((item)=>{
      if(item.id === id){
        return val
      } return item
    })
    this.fileList = newFileList
  }

  setUploadInfoList = (id: string, val: any) => {
    const newFileList = this.fileList?.map((item)=>{
        if(item.id === id){
          return {...item, info: {...item.info, ...val}}
        } return item
      })
      this.fileList = newFileList
  }
}

const fileListStore = new FileList()

export default fileListStore
