import { useState, useCallback, useEffect, useMemo } from "react";
import classnames from "classnames";
import style from "./index.module.css";
import CloseIcon from "@mui/icons-material/Close";
import MyButton from "@/components/mui/MyButton";
import InsertDriveFileOutlinedIcon from "@mui/icons-material/InsertDriveFileOutlined";
import CloudEController from "@/api/fileserver/CloudEController";
import { useStores } from "@/store";
import { toJS } from "mobx";
import FullScreenDrawer from "@/components/CommonComponents/FullScreenDrawer";
import ChevronLeftIcon from '@mui/icons-material/ChevronLeft';
import ChevronRightIcon from '@mui/icons-material/ChevronRight';


type LogViewProps = {
    logs: any[];
    setShowLogView: any;
};

const LogView = (props: LogViewProps) => {
    const { logs, setShowLogView } = props;
    const { currentProjectStore } = useStores();
    const fileToken = toJS(currentProjectStore.currentProjectInfo.filetoken);
    const projectId = toJS(currentProjectStore.currentProjectInfo.id);
    // 当前选择的日志
    const [logCurrent, setLogCurrent] = useState<number>(0);
    // 当前日志的内容文本
    const [logText, setLogText] = useState('')
    // 当前日志路径
    const [logPath, setLogPath] = useState('')

    useEffect(() => {
        setLogPath(logs[logCurrent]?.logPath)
    }, [logs]);

    // 请求日志文本
    useEffect(() => {
        if (logPath) {
            const path = logPath.slice(12)
            CloudEController.JobFileDownloadText(
                path,
                fileToken as string,
                projectId as string
            )?.then((res) => {
                setLogText(res.data)
            })
        } else {
            setLogText("")
        }
    }, [logPath]);

    // 选择日志时改变日志路径
    useEffect(() => {
        setLogPath(logs[logCurrent]?.logPath)
    }, [logCurrent]);

    // 下载当前日志
    const handleDownLoad = () => {
        const path = logPath.slice(12)
        CloudEController.JobFileDownload(
            path,
            fileToken as string,
            projectId as string
        );
    }

    return (
        <FullScreenDrawer handleClose={setShowLogView} zIndex={1002}>
            <div className={style.logViewBox}>
                <div className={style.logViewContentMask}></div>
                <div className={style.logViewTop}>
                    <div className={style.leftButton}><ChevronLeftIcon /></div>
                    <div className={style.middleFixed}>
                        <div className={style.middleDynamic}>
                            {logs.map((item: any, index: number) => {
                                return <div
                                    key={index}
                                    onClick={() => { setLogCurrent(index) }}
                                    className={classnames({
                                        [style.logTitle]: true,
                                        [style.logTitleSelected]: index === logCurrent,
                                    })}>
                                    <InsertDriveFileOutlinedIcon className={style.fileIcon} />
                                    <span className={style.logName}>{item.logName}</span>
                                </div>
                            })}
                        </div>
                    </div>
                    <div className={style.rightButton}><ChevronRightIcon /></div>
                </div>
                <div className={style.logViewContent}>
                    {logText}
                </div>
                <div className={style.logViewBottom}>
                    <MyButton text='下载当前日志' onClick={handleDownLoad} />
                </div>
            </div>
        </FullScreenDrawer>
    )
}

export default LogView