/*
 * @Author: 吴永生 15770852798@163.com
 * @Date: 2022-08-15 15:03:10
 * @LastEditors: 吴永生 15770852798@163.com
 * @LastEditTime: 2022-08-23 19:39:21
 * @FilePath: /bkunyun/src/views/Project/ProjectJobDetail/utils.ts
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */

import { IEdge, ITask } from "../ProjectSubmitWork/interface";
import { IFlowNodeTransmissionNum } from "./interface";

// 根据outputs的路径获取数据集的路径
export const getDatasetPath = (path: string) => {
  let datasetPath = "";
  const noProjectPath = path.slice(12);
  const fileIndex = noProjectPath.indexOf("/.dataset");
  if (fileIndex !== -1) {
    datasetPath = noProjectPath.slice(0, fileIndex);
  } else {
    datasetPath = noProjectPath;
  }
  return datasetPath ? datasetPath : "/";
}; 


// 根据outputs的路径获取数据集的名称
export const getDatasetName = (path: string) => {
  let name='';
  const arr = path.split('/.dataset/');
  if(arr.length === 2) {
    name = arr[1]
  }
  return name
};

/** 根据批节点 判断是否在同一个批 */
export const getSameBatch = (flowNodeInfo: IFlowNodeTransmissionNum[], task: ITask) => {
  return flowNodeInfo.some(every=>{
    return every.batchId === task.parentNode
  })
}

/** 连接的数组 */
export const getConnectionArr = (flowNodeInfo: IFlowNodeTransmissionNum[], edge: IEdge) => {
  return flowNodeInfo.filter(every => {
    return every.source === edge?.source && every.target === edge?.target
  })
}



