import QueueSelect from "@/components/BusinessComponents/QueueSelect";
import { useEffect, useState } from "react";
import useMyRequest from "@/hooks/useMyRequest";
import { getHardwreList } from "@/api/project_api";
import { IQueueLi } from "@/components/BusinessComponents/QueueSelect";

const QueueSelectDemo = () => {
	const [value, setValue] = useState("");
	const [cpuList, setCpuList] = useState<Array<IQueueLi>>([]);
	const [gpuList, setGpuList] = useState<Array<IQueueLi>>([]);
	const onChange = (e: any) => {
		setValue(e);
	};
	const { run } = useMyRequest(getHardwreList, {
		onSuccess: (res, params) => {
			if (params[0].computeType === "CPU") {
				setCpuList(res.data);
			} else {
				setGpuList(res.data);
			}
		},
	});
	useEffect(() => {
		run({
			zoneId: "CE-Z1",
			computeType: "CPU",
		});
	}, [run]);
	useEffect(() => {
		run({
			zoneId: "CE-Z1",
			computeType: "GPU",
		});
	}, [run]);

	return (
		<>
			<QueueSelect
				value={value}
				onChange={onChange}
				originalCpuList={cpuList}
				originalGpuList={gpuList}
			></QueueSelect>
		</>
	);
};

export default QueueSelectDemo;
