/*
 * @Author: 吴永生#A02208 yongsheng.wu@wholion.com
 * @Date: 2022-06-17 14:48:57
 * @LastEditors: 吴永生 15770852798@163.com
 * @LastEditTime: 2022-07-26 18:35:33
 * @FilePath: /bkunyun/src/views/Project/ProjectWorkbench/workbenchTemplate/components/templateBox.tsx
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import { memo, useCallback } from "react";
import styles from "../index.module.css";
import { Box, Typography } from "@mui/material";
import MyButton from "@/components/mui/MyButton";
import usePass from "@/hooks/usePass";
import { useNavigate } from "react-router-dom";

const TemplateBox = (props: any) => {
	const info = props.data;
	const isPass = usePass();
	const navigate = useNavigate();

	const addTemplateBlock = useCallback(
		(id: string) => {
			navigate(`/product/cadd/projectSubmitWork`, {
				state: { id },
			});
		},
		[navigate]
	);

	return (
		<Box className={styles.template}>
			<Box className={styles.templateBlock}>
				<Box>
					<Box
						sx={{
							display: "flex",
							justifyContent: "space-between",
							alignItems: "center",
						}}
					>
						<Typography
							sx={{
								fontSize: "14px",
								fontWeight: "600",
								color: "#1E2633",
								marginBottom: "4px",
								overflow: "hidden",
								textOverflow: "ellipsis",
							}}
						>
							{info.title}
						</Typography>
						{info.creator !== "root" && (
							<Box
								sx={{
									backgroundColor: "rgba(227, 250, 236, 1)",
									color: "rgba(2, 171, 131, 1)",
									lineHeight: "20px",
									padding: "1px 9px",
									fontSize: "12px",
								}}
							>
								自定义
							</Box>
						)}
					</Box>
					<Box sx={{ display: "flex", marginBottom: "8px" }}>
						<Typography
							sx={{
								fontSize: "12px",
								fontWeight: "400",
								color: "#1370FF",
								marginRight: "24px",
							}}
						>
							版本：{info.version}
						</Typography>
						<Typography
							sx={{ fontSize: "12px", fontWeight: "400", color: "#1370FF" }}
						>
							更新时间：{info.updatedTime}
						</Typography>
					</Box>
					<Typography className={styles.templateDescText}>
						{info.description ? info.description : "此模板暂无描述。"}
					</Typography>
				</Box>
				<Box
					sx={{
						display: "flex",
						justifyContent: "end",
					}}
				>
					{isPass("PROJECT_WORKBENCH_FLOES_USE", "MANAGER") && (
						<MyButton
							size="medium"
							text="删除模版"
							onClick={() => {
								props.startDialog(info.id);
							}}
							style={{ backgroundColor: "#F0F2F5", color: "#565C66" }}
						/>
					)}
					{isPass("PROJECT_WORKBENCH_FLOES_USE", "USER") && (
						<MyButton
							size="medium"
							text="使用模版"
							onClick={() => addTemplateBlock(info.id)}
							style={{ marginLeft: "12px" }}
						/>
					)}
				</Box>
			</Box>
		</Box>
	);
};

export default memo(TemplateBox);
