// 分页组件
import Pagination from "@mui/material/Pagination";
import MySelect from "./MySelect";
import { ThemeProvider, createTheme } from "@mui/material/styles";

const theme = createTheme({
	components: {
		MuiPagination: {
			styleOverrides: {
				ul: {
					flexWrap: "nowrap",
				},
			},
		},
		MuiPaginationItem: {
			styleOverrides: {
				root: {
					"&.Mui-selected": {
						background: "rgba(19, 112, 255, 1)",
						color: "#fff",
						":hover": {
							background: "rgba(19, 112, 255, 1)",
							color: "#fff",
						},
					},
				},
			},
		},
	},
});

type IMyPaginationProps = {
	page: number;
	pageChange: any;
	count: number;
	totalElements?: number;
	type?: "simple" | "complex";
	rowsPerPage?: number; // 每页多少条数据
	handleChangeRowsPerPage?: any;
};

const MyPagination = (props: IMyPaginationProps) => {
	const {
		page,
		pageChange,
		count,
		type = "simple",
		rowsPerPage = 10,
		handleChangeRowsPerPage,
		totalElements = 0,
	} = props;

	const handlePageChange = (e: any, value: number) => {
		pageChange && pageChange(value);
	};
	const rowsPerPageChange = (e: any) => {
		handleChangeRowsPerPage(Number(e));
	};
	return (
		<ThemeProvider theme={theme}>
			{type === "complex" && (
				<>
					<span
						style={{
							marginRight: "20px",
							fontSize: "14px",
							color: "rgba(30, 38, 51, 1)",
						}}
					>
						总计：{totalElements}
					</span>
					<MySelect
						style={{ marginRight: "20px" }}
						value={String(rowsPerPage)}
						onChange={(e) => rowsPerPageChange(e)}
						size={"small"}
						options={[
							{
								label: "10/页",
								value: "10",
							},
							{
								label: "20/页",
								value: "20",
							},
							{
								label: "50/页",
								value: "50",
							},
							{
								label: "100/页",
								value: "100",
							},
						]}
					></MySelect>
				</>
			)}

			<Pagination
				page={page + 1} // 请求接口的页码是从0开始的
				count={count + 1}
				shape="rounded"
				onChange={handlePageChange}
			/>
		</ThemeProvider>
	);
};

export default MyPagination;
