import { useEffect, useMemo, useState } from "react";
import MyTable from "@/components/mui/MyTableNew";
import { sortState } from "@/components/mui/MyTableNew";

type IDatasetTableProps = {
	list: Array<any>;
	showData: Array<string>;
	selectItems: Array<any>;
	setSelectItems: any;
	sortState: sortState;
	setSortState: any;
	loading: boolean;
};

const DatasetTable = (props: IDatasetTableProps) => {
	const {
		list,
		showData,
		selectItems,
		setSelectItems,
		sortState,
		setSortState,
		loading,
	} = props;
	const [innerWidth, setInnerWidth] = useState(window.innerWidth);
	useEffect(() => {
		window.addEventListener("resize", () => {
			setInnerWidth(window.innerWidth);
		});
	}, []);

	const headCells = useMemo(() => {
		let width =
			showData.length === 0
				? innerWidth - 112
				: `${(innerWidth - 112) / showData.length}`;
		return showData.map((item) => {
			return {
				id: item,
				label: item,
				width,
				showOverflowTooltip: true,
				sort: true,
			};
		});
	}, [showData, innerWidth]);
	return (
		<MyTable
			rows={list}
			headCells={headCells}
			hasCheckbox={true}
			fixedHead={true}
			selectItems={selectItems}
			setSelectItems={setSelectItems}
			sortState={sortState}
			setSortState={setSortState}
			loading={loading}
		></MyTable>
	);
};

export default DatasetTable;
