import React from 'react'
import { Grid , Typography } from '@material-ui/core'
import icondelete from '../../assets/img/iconDelete.svg'
import iconDashboard from '../../assets/img/iconDashboard.svg'
import { makeStyles } from '@material-ui/core'
const Style = makeStyles({
    paddingbox:{
        borderRadius: '4px',
        border:' 1px solid rgba(19, 110, 250, 1)',
        cursor:'pointer',
        minHeight:'33px',
        display:'flex',
        alignItems:'center',
        // justifyContent:'center'
    },
    content:{
        color:'rgba(19, 110, 250, 1)',
        fontSize:'13px',
        lineHeight:'17px',
        fontWeight:'400',
        fontFamily:'PingFangSC-Regular, PingFang SC'
    },
    img:{
        // width:'17px',
        marginRight:'4px'
    }
})

export default props =>{
    const { startIcon = '' , color , onClick , text = '' , marginright = '16px' ,style={} , paddingleft='' } = props
    const classes = Style()
    const  icon =  (str)=>{
        switch(str){
            case 'delete' :
                return icondelete;
            case 'dashboard':
                return iconDashboard;
            default:
                break;
        }
    }

    return <Grid onClick = {()=>{onClick&&onClick()}} className = {classes.paddingbox}
     style={{padding:Boolean(startIcon)?'3px 14px 3px 7px':' 6px 8px ',marginRight:marginright,paddingLeft:paddingleft, ...style}}>
        {startIcon&& <img src ={icon(startIcon)} alt ='' className= {classes.img}/>}
        <Typography className={classes.content}>{ text }</Typography>
    </Grid>
}