/*
 * @Author: 吴永生#A02208 yongsheng.wu@wholion.com
 * @Date: 2022-06-14 17:22:15
 * @LastEditors: 吴永生#A02208 yongsheng.wu@wholion.com
 * @LastEditTime: 2022-06-14 17:22:56
 * @FilePath: /bkunyun/src/hooks/useDeepEffect.ts
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import { useEffect, useRef } from 'react';
import _ from 'lodash';

export default function useDeepEffect(effectFunc: Function, deps: any[]) {
  const isFirstRef = useRef(true);
  const preDeps = useRef(deps);
  useEffect(() => {
    const isSame = preDeps.current.every((obj, index) => {
      return _.isEqual(obj, deps[index]);
    });
    if (isFirstRef.current || !isSame) {
      effectFunc();
    }
    isFirstRef.current = false;
    preDeps.current = deps;
  }, [deps]);
}
