/*
 * @Author: 吴永生#A02208 yongsheng.wu@wholion.com
 * @Date: 2022-07-12 11:29:46
 * @LastEditors: 吴永生 15770852798@163.com
 * @LastEditTime: 2022-08-22 19:16:06
 * @FilePath: /bkunyun/src/views/Project/components/Flow/components/FlowNode/index.tsx
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import classNames from "classnames";
import { Handle, Position } from "react-flow-renderer";
import { useMemo } from "react";
// import { IParameter } from "@/views/Project/ProjectSubmitWork/interface";
import { uuid } from "@/utils/util";

import { IExecutionStatus } from "@/views/Project/ProjectSubmitWork/interface";
import jobFail from "@/assets/project/jobFail.svg";
import jobRun from "@/assets/project/jobRun.svg";
import jobSue from "@/assets/project/jobSue.svg";
import MyTooltip from "@/components/mui/MyTooltip";

import styles from "./index.module.css";
/** 自定义flow节点 */
const FlowNode = (props: any) => {
	/** 获取imgUrl */
	const getImgUrl = (type: IExecutionStatus) => {
		if (type === "Done") {
			return jobSue;
		}
		if (type === "Failed") {
			return jobFail;
		}
		if (type === "Running") {
			return jobRun;
		}
		return undefined;
	};

	const { data } = props;
	const {
		selectedStatus,
		flowNodeStyle = { display: "flex", alignItems: "center" }, // 样式
		inStyle = { background: "#C2C6CC ", left: 12 }, // 样式
		outStyle = { background: "#C2C6CC ", left: 12 }, // 样式
		flowType,
		info: { title, isCheck, executionStatus, parameters, version },
		showVersion,
	} = data;

	/** 获取输入参数数组 */
	const inParamsArr = useMemo(() => {
		return (
			(parameters?.length &&
				parameters?.filter((item: any) => {
					return item.parameterGroup === "in";
					// return item.parameterGroup === "in" && !item?.thrown;
				})) ||
			[]
		);
	}, [parameters]);

	/** 获取输出参数数组 */
	const outParamsArr = useMemo(() => {
		return (
			(parameters?.length &&
				parameters?.filter((item: any) => {
					return item.parameterGroup === "out";
					// return item.parameterGroup === "out" && !item?.thrown;
				})) ||
			[]
		);
	}, [parameters]);

	return (
		<div
			style={flowNodeStyle}
			className={classNames({
				[styles.flowNode]: true,
				[styles.selectedFlowBox]: selectedStatus,
			})}
		>
			{inParamsArr?.length
				? inParamsArr.map((item: any, index: number) => {
						return (
							<MyTooltip title={item.name} key={uuid()}>
								<Handle
									className={styles.handleBox}
									id={item.name}
									style={{
										background: "#fff ",
										border: "1px solid #D1D6DE",
										...inStyle,
										left: index * 24 + 16,
									}}
									type="target"
									position={Position.Top}
								/>
							</MyTooltip>
						);
				  })
				: null}
			<div style={{display: 'flex', alignItems: 'center'}}>
				<span style={{fontSize: '12px', lineHeight: '24px'}}>{title || ""} {showVersion && version}</span>
				{flowType !== "edit" && isCheck ? (
					<span className={styles.successDot}></span>
				) : null}
				{flowType === "edit" && isCheck === false ? (
					<span className={styles.errorDot}></span>
				) : null}
				{getImgUrl(executionStatus) && (
					<img
						style={{ marginLeft: "6px" }}
						src={getImgUrl(executionStatus)}
						alt=""
					/>
				)}
			</div>
			{outParamsArr?.length
				? outParamsArr.map((item: any, index: number) => {
						return (
							<MyTooltip title={item.name} key={uuid()}>
								<Handle
									className={styles.handleBox}
									id={item.name}
									style={{
										background: "#fff ",
										border: "1px solid #D1D6DE",
										...outStyle,
										left: index * 24 + 16,
									}}
									type="source"
									position={Position.Bottom}
								/>
							</MyTooltip>
						);
				  })
				: null}
		</div>
	);
};

export default FlowNode;
