import React from "react";
import { Typography } from "@material-ui/core";
import PropTypes from "prop-types";
import makeStyles from "@material-ui/styles/makeStyles";
const useStyles = makeStyles({
    h3: { fontSize: "24px" },
    h4: { fontSize: "20px" },
    h5: { fontSize: "16px" },
    body1: { fontSize: "14px" },
    subtitle1: { fontSize: "13px" },
    subtitle2: { fontSize: "12px" },
    colorInherit: { color: "#222222" },
    colorInherit_hover: { color: "#222222", "&:hover": { color: "#136EFA" } },
    colorSecondary: { color: "#00CCCC" },
    colorError: { color: "#FF4E4E" },
    colorTextPrimary: { color: "#0DD09B" },
    HiddenRoot: {
        overflow: 'hidden',
        textOverflow: 'ellipsis',
        display: '-webkit-box',
        WebkitBoxOrient: 'vertical',
    },
    line: {
        overflow: 'hidden',
        textOverflow: 'ellipsis',
        whiteSpace: 'nowrap',
    }
});
const TextComponent = props => {
    const classes = useStyles();
    const fontWT = (fontWeight) => {
        switch (fontWeight) {
            case "small":
                return 300;
            case "large":
                return 500;
            case "big":
                return 600;
            case "bigger":
                return 800;
            default:
                return 400;

        }
    }
    const opacityFun = (value) => {
        switch (value) {
            case 'l':
                return 0.05
            case 'm':
                return 0.08
            case 'mh':
                return 0.1
            case 'h':
                return 0.15
            case 'xs':
                return 0.25
            case 'ss':
                return 0.3
            case 'sm':
                return 0.45
            case 'mm':
                return 0.5
            case 'md':
                return 0.65
            case 'gx':
                return 0.8
            case 'lg':
                return 0.85
            default:
                return 1
        }
    }
    const { text, align, color, display, gutterBottom, variant, fw, op, style, wordBreak, line, click, hover, hoverClass = false } = props;
    const defaultClick = () => { }
    const stylesFun = () => {
        return {
            wordBreak: wordBreak ? "break-all" : "keep-all",
            textTransform: "none",
            ...style,
            fontWeight: fontWT(fw),
            opacity: opacityFun(op),
            WebkitLineClamp: line && line.num ? line.num : 1,
            width: line && line.width ? line.width : "auto",
            maxWidth: line && line.maxWidth ? line.maxWidth : "100%",
        }
    }
    return (
        <Typography
            align={align || "inherit"}
            color={color || "inherit"}
            display={display || "initial"}
            gutterBottom={gutterBottom || false}
            variant={variant || "body1"}
            onClick={click || defaultClick}
            classes={{
                h3: classes.h3,
                h4: classes.h4,
                h5: classes.h5,
                body1: classes.body1,
                subtitle1: classes.subtitle1,
                subtitle2: classes.subtitle2,

                colorInherit: hover ? (hoverClass || classes.colorInherit_hover) : classes.colorInherit,
                colorSecondary: classes.colorSecondary,
                colorTextPrimary: classes.colorTextPrimary,
                colorError: classes.colorError,
                root: line ? (line.num && line.num === 1 ? classes.line : classes.HiddenRoot) : classes.root
            }}
            style={stylesFun()}
        >
            {text || ''}
        </Typography>
    )
}

TextComponent.propTypes = {
    fw: PropTypes.oneOf(["bigger","big", "large", "medium", "small"]),
    variant: PropTypes.oneOf(['h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'subtitle1', 'subtitle2', 'body1', 'body2', 'caption', 'button', 'overline', 'srOnly', 'inherit']),
    color: PropTypes.oneOf(["initial", "inherit", "primary", "secondary", "textPrimary", "textSecondary", "error"]),
    op: PropTypes.oneOf(['', 'l', 'm', 'mh', 'h', 'xs', 'ss', 'sm', 'mm', 'md', 'lg', 'gx', 'xl']),
};

export default TextComponent