import { makeAutoObservable } from "mobx";
import { route } from "@/router";

type projectList = Array<{
  id: string;
  name: string;
  icon: string;
  type: "product" | "utility";
  routes: Array<route>;
}>;

class Menus {
  constructor() {
    makeAutoObservable(this);
  }

  productList: Array<{
    name: string;
    path: string;
    id: string;
  }> = [];

  utilityList: Array<{
    name: string;
    path: string;
    id: string;
  }> = [];

  initMenu = (list: projectList) => {
    this.productList = [];
    this.utilityList = [];
    for (let item of list) {
      if (item.type === "product") {
        this.productList.push({
          name: item.name,
          path: item.routes[0].path,
          id: item.id,
        });
      } else if (item.type === "utility") {
        this.utilityList.push({
          name: item.name,
          path: item.routes[0].path,
          id: item.id,
        });
      }
    }
  };
}

const menuStore = new Menus();

export default menuStore;
