/*
 * @Author: 吴永生 15770852798@163.com
 * @Date: 2022-08-02 11:43:28
 * @LastEditors: 吴永生 15770852798@163.com
 * @LastEditTime: 2022-08-03 19:05:48
 * @FilePath: /bkunyun/src/views/MenuLayout/index.tsx
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import { Box, List } from "@mui/material";
import CurrentProject from "../Project/components/CurrentProject";
import React from "react";
import { Outlet, useNavigate } from "react-router-dom";
import style from "./index.module.css";
import { observer } from "mobx-react-lite";
import { useStores } from "@/store/index";
import classnames from "classnames";
import { toJS } from "mobx";

const MenuLayout = observer(() => {
  const { permissionStore, currentProjectStore } = useStores();
  let pathname = new URL(window.location.href).pathname;

  const navigate = useNavigate();

  const productInfo = toJS(currentProjectStore.currentProductInfo);

  // 未选择产品时 直接跳转home页面
  if (!productInfo.name) {
    navigate("/home");
  }

  const routerIcon = (id: string, isSelect: boolean) => {
    try {
      const result = require(`../../assets/project/${id}${isSelect ? '_BLUE' : ''}.svg`)
      return result || ''
    } catch (error) {
      console.log(error)
    }
  }

  return (
    <Box className={style.container}>
      <Box className={style.aside}>
        {
          pathname.indexOf('userCenter') < 0 && <CurrentProject />
        }
        <List
          sx={{
            paddingTop: 0,
            paddingBottom: 0,
          }}
        >
          {permissionStore.sidebarRouters.map((item, index) => {
            if (item.show) {
              return (
                <li
                  key={"sidebar" + index}
                  className={classnames({
                    [style.listItem]: true,
                    [style.active]: `/v3${item.path}` === pathname,
                  })}
                  onClick={() => item.type === "page" && navigate(item.path)}
                >
                  <img className={style.routerIcon} src={routerIcon(item.id || '', `/v3${item.path}` === pathname) || undefined} alt='' />
                  <span style={{ verticalAlign: 'middle', fontWeight: '500' }}>{item.name}</span>
                </li>
              );
            }
            return null;
          })}
        </List>
      </Box>
      <Box className={style.content}>
        <Outlet></Outlet>
      </Box>
    </Box>
  );
});

export default MenuLayout;
