/*
 * @Author: 吴永生#A02208 yongsheng.wu@wholion.com
 * @Date: 2022-06-21 15:25:25
 * @LastEditors: 吴永生 15770852798@163.com
 * @LastEditTime: 2022-08-09 16:07:33
 * @FilePath: /bkunyun/src/views/Project/ProjectSubmitWork/WorkFlow/index.tsx
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import { useEffect } from "react";
import Flow from "../../components/Flow";
import { ITemplateConfig } from "../interface";

interface IProps {
	templateConfigInfo?: ITemplateConfig;
	setSelectedBatchNodeId?: (val: string) => void;
	selectedBatchNodeId?: string;
}
const WorkFlow = (props: IProps) => {
	const { templateConfigInfo, setSelectedBatchNodeId, selectedBatchNodeId } =
		props;

	/** 页面刷新提醒 */
	const pageRefreshTips = (e: any) => {
		const event: any = window.event || e;
		event.returnValue = "是否离开网站？";
	};

	/** 监听页面刷新事件 */
	useEffect(() => {
		window.addEventListener("beforeunload", pageRefreshTips, false);
		return () => {
			window.removeEventListener("beforeunload", pageRefreshTips, false);
		};
	});

	return (
		<Flow
			tasks={templateConfigInfo?.tasks}
			setSelectedBatchNodeId={setSelectedBatchNodeId}
			selectedBatchNodeId={selectedBatchNodeId}
		/>
	);
};

export default WorkFlow;
