import 'date-fns';
import React, { useState } from 'react';
import { Grid, Typography } from '@material-ui/core';
import DateFnsUtils from '@date-io/date-fns';
import {
    MuiPickersUtilsProvider,
    KeyboardDatePicker,
} from '@material-ui/pickers';
import makeStyles from "@material-ui/styles/makeStyles";
import frLocale_cn from "date-fns/locale/zh-CN";
import frLocale_en from "date-fns/locale/en-US";
import { isEn } from "../../../commons/utils/helper.js";
const frLocale = isEn() ? frLocale_en : frLocale_cn
const useStyles = makeStyles({
    dateInputBox: {
        width: "8.125rem",
        boxSizing: "border-box",
    },
    dateInputBody: {
        height: "36px !important",
    },
    root: {
        margin: "0",
        background: "#FFFFFF",
        borderRadius: "4px",
        border: "1px solid #D8D8D8",
    },
    input: {
        fontSize: "0.8125rem",
        padding: "8px 0 8px 8px",
        marginRight: "-10px"
    },
    label: {
        opacity: "0.3",
    },
    rootButton: {
        background: "none",
        backgroundColor: "none",
        '&:hover': {
            background: "none",
            backgroundColor: "none"
        },
        '&:before': {
            background: "none",
            backgroundColor: "none"
        },
        '&:hover:before': {
            background: "none",
            backgroundColor: "none"
        },
        '&:after': {
            background: "none",
            backgroundColor: "none"
        }
    },
    underline: {
        border: "none",
        content: "",
        borderBottom: "none",
        '&:before': {
            border: "none",
            content: "",
            borderBottomStyle: "none !important",
            borderBottom: "none",
        },
        '&:hover:before': {
            border: "none",
            content: "",
            borderBottom: "none",
        },
        '&:after': {
            border: "none",
            content: "",
            borderBottom: "none",
        }
    },
    calendar_body: {
        display: 'flex',
        marginLeft: "-0.5rem",
        alignItems: "center",
        justifyContent: "center",
        marginRight: "10px",
        height: "36px",
        marginLeft: "10px"
    },
    lineFiltrate: {
        width: '1rem',
        height: "1px",
        backgroundColor: "#D8D8D8",
        margin: "0 0.3125rem"
    },
})
export default function MaterialUIPickers(props) {
    const { startTime, endTime, DateChange, lastDate } = props;
    const [openDatePicker, setOpenDatePicker] = useState({
        one: false,
        two: false,
    })
    const classes = useStyles()
    const openCalendar = (type, date) => {
        setOpenDatePicker({
            one: type === 'start' ? date : openDatePicker[`${type === 'start' ? 'one' : 'two'}`],
            two: type === 'end' ? date : openDatePicker[`${type === 'start' ? 'one' : 'two'}`],
        })
    };
    const closeCalendar = () => {
        setOpenDatePicker({
            one: false,
            two: false,
        })
    };
    const handleDateChange = (type, date) => {
        let d = new Date(date);
        DateChange(type, d)
        setOpenDatePicker({
            one: false,
            two: false,
        })
    }
    const Calendar = (type) => {
        return (
            <Grid container item className={classes.dateInputBox}>
                <MuiPickersUtilsProvider utils={DateFnsUtils} locale={frLocale}  >
                    <Grid container justifycontent="space-around" className={classes.dateInputBody}>
                        <KeyboardDatePicker
                            disableToolbar
                            variant="inline"
                            open={openDatePicker[`${type === 'start' ? 'one' : 'two'}`]}
                            format={isEn() ? "MM/dd/yyyy" : "yyyy-MM-dd"}
                            disableFuture
                            minDate={lastDate ? new Date(lastDate) : new Date("1900-01-01")}
                            margin="normal"
                            id="date-picker-inline"
                            onClick={() => openCalendar(type, true)}
                            onOpen={() => openCalendar(type, true)}
                            onClose={() => closeCalendar()}
                            value={type === 'start' ? startTime : endTime}
                            onChange={(date) => handleDateChange(type, date)}
                            InputProps={{
                                classes: {
                                    input: classes.input,
                                    underline: classes.underline
                                },
                            }}
                            classes={{
                                root: classes.root
                            }}
                            KeyboardButtonProps={{
                                'aria-label': 'change date',
                                classes: {
                                    root: classes.rootButton,
                                    label: classes.label
                                },
                            }}
                        />
                    </Grid>
                </MuiPickersUtilsProvider>
            </Grid>
        )
    }
    return (
        <Grid className={classes.calendar_body}>
            {Calendar('start')}
            <Typography className={classes.lineFiltrate}></Typography>
            {Calendar('end')}
        </Grid>
    );
}