/*
 * @Author: 吴永生 15770852798@163.com
 * @Date: 2022-10-24 17:32:00
 * @LastEditors: 吴永生 15770852798@163.com
 * @LastEditTime: 2022-10-24 19:42:23
 * @FilePath: /bkunyun/src/views/CustomOperator/index.tsx
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import React, { useCallback, useEffect, useState } from "react";
import { observer } from "mobx-react-lite";
import FullScreenDrawer from "@/components/CommonComponents/FullScreenDrawer";
import MyButton from "@/components/mui/MyButton";
import OperatorList from "./components/OperatorList";
// import Flow from "../Project/components/Flow";
import BatchOperatorFlow from "../Project/components/Flow/components/BatchOperatorFlow";
import SaveOperator from "./components/SaveOperator";
import { ITask } from "../Project/ProjectSubmitWork/interface";
import _ from "lodash";
import styles from "./index.module.css";
import useCheckOperator from "./useCheckOperator";

type IProps = {
	setShowCustomOperator: any;
	initOperatorList: ITask[];
	productId: string;
};

const CustomOperator = observer((props: IProps) => {
	const { setShowCustomOperator, initOperatorList, productId } = props;
	const [operatorList, setOperatorList] = useState<ITask[]>(initOperatorList);
	const [saveFormDialog, setSaveFormDialog] = useState(false);
	const [inputActive, setInputActive] = useState(false);
	// const [showCustomOperator, setShowCustomOperator] = useState(false);

	const { handleCheck } = useCheckOperator(operatorList, () =>
		setSaveFormDialog(true)
	);

	/** 设置选中唯一标识符 */
	const handleNodeClick = useCallback((val: string) => {
		// setSelectTaskId(val);
	}, []);

	useEffect(() => {
		sessionStorage.setItem("operatorList", JSON.stringify(operatorList));
	}, [operatorList]);

	return (
		<FullScreenDrawer handleClose={setShowCustomOperator} zIndex={1100}>
			<div className={styles.customOperator}>
				<div className={styles.coTop}>
					<div className={styles.coTitle}>添加算子</div>
					<MyButton
						text="添加"
						onClick={() => {
							handleCheck();
						}}
					></MyButton>
					<SaveOperator
						saveFormDialog={saveFormDialog}
						setSaveFormDialog={setSaveFormDialog}
						operatorList={operatorList}
						setShowCustomOperator={setShowCustomOperator}
					></SaveOperator>
				</div>
				<div className={styles.coContent} id="customOperatorFlow">
					<OperatorList
						operatorList={operatorList}
						setOperatorList={setOperatorList}
						setInputActive={setInputActive}
						productId={productId}
					/>
					<BatchOperatorFlow
						tasks={operatorList}
						setTasks={setOperatorList}
						type="edit"
						onFlowNodeClick={handleNodeClick}
						flowNodeDraggable={true}
						ListenState={!saveFormDialog && !inputActive}
						showVersion={true}
						showControls={false}
					/>
				</div>
			</div>
		</FullScreenDrawer>
	);
});

export default CustomOperator;
