// 应用环境
import { useEffect, useState } from "react";
import { useNavigate } from "react-router-dom";
import style from "./index.module.css";
import SearchInput from "@/components/BusinessComponents/SearchInput";
import MySelect from "@/components/mui/MySelect";
import MyButton from "@/components/mui/MyButton";
import MyTable, { sortState } from "@/components/mui/MyTableNew";
import useMyRequest from "@/hooks/useMyRequest";
import { getActorenvList } from "@/api/resourceCenter";
import Add from "@mui/icons-material/Add";
import moment from "moment";
import jobFail from "@/assets/project/jobFail.svg";
import jobRun from "@/assets/project/jobRun.svg";
import jobSue from "@/assets/project/jobSue.svg";
import AddEnvironment from "./AddEnvironment";
import DeleteEnvironment from "./DeleteEnvironment";

const UserResourcesEnvironment = () => {
	const navigate = useNavigate();
	const [addOpen, setAddopen] = useState(false);
	const [title, setTitle] = useState("");
	const [type, setType] = useState<"BATCH" | "FLOW" | "ALL">("ALL");
	const [list, setList] = useState([]);
	const [page, setPage] = useState(0);
	const [count, setCount] = useState(0);
	const [size, setSize] = useState(20);
	const [id, setId] = useState("");
	const [deleteOpen, setDeleteOpen] = useState(false);
	const [totalElements, setTotalElements] = useState(0);
	const [sortState, setSortState] = useState<sortState>({
		field: "createdTime",
		order: "DESC",
	});
	const headCells: Array<any> = [
		{
			id: "title",
			label: "环境名称",
		},
		{
			id: "type",
			label: "环境类型",
			width: 100,
		},
		{
			id: "createdTime",
			label: "创建时间",
			width: 180,
			sort: true,
		},
		{
			id: "status",
			label: "构建状态",
			width: 150,
		},
		{
			id: "caozuo",
			label: "操作",
			width: 140,
		},
	];
	const { run: getList, loading } = useMyRequest(getActorenvList, {
		onSuccess: (res) => {
			setList(res.data.content);
			setCount(res.data.totalPages - 1);
			setTotalElements(res.data.totalElements);
		},
	});

	const pageChange = (value: number) => {
		setPage(value - 1);
	};

	useEffect(() => {
		if (!addOpen && !deleteOpen) {
			getList({
				page,
				size,
				title,
				type: type === "ALL" ? "" : type,
				order: sortState.order || "DESC",
			});
		}
	}, [getList, page, size, title, type, addOpen, deleteOpen, sortState]);

	const renderType = (item: any) => {
		if (item.type === "BATCH") {
			return "批式";
		} else if (item.type === "FLOW") {
			return "流式";
		} else {
			return "";
		}
	};

	const renderStatus = (item: any) => {
		if (item.status === "PENDING") {
			return (
				<div className={style.statusBox}>
					<img src={jobRun} alt="" />
					<span className={style.status}>准备构建</span>
				</div>
			);
		} else if (item.status === "CREATING") {
			return (
				<div className={style.statusBox}>
					<img src={jobRun} alt="" />
					<span className={style.status}>正在构建</span>
				</div>
			);
		} else if (item.status === "FAILED") {
			return (
				<div className={style.statusBox}>
					<img src={jobFail} alt="" />
					<span className={style.status}>构建失败</span>
				</div>
			);
		} else if (item.status === "CREATED") {
			return (
				<div className={style.statusBox}>
					<img src={jobSue} alt="" />
					<span className={style.status}>构建完成</span>
				</div>
			);
		} else {
			return "";
		}
	};

	const renderCreatedTime = (item: any) => {
		return moment(new Date(item.createdTime)).format("yyyy-MM-DD hh:mm:ss");
	};

	const handleDelete = (item: any) => {
		setId(item.id);
		setDeleteOpen(true);
	};

	const hanleToSeeEnv = (item: any) => {
		navigate("/utility/resourceCenter/userResources/seeEnv", {
			state: { id: item.id },
		});
	};

	const renderButtons = (item: any) => {
		if (item.status === "FAILED") {
			return (
				<>
					<MyButton
						text="详情"
						style={{
							position: "relative",
							left: "-10px",
							minWidth: "10px",
							height: "22px",
							padding: "0 10px",
						}}
						variant="text"
						size="medium"
						onClick={() => hanleToSeeEnv(item)}
					/>
					<MyButton
						onClick={() => handleDelete(item)}
						text="删除"
						style={{
							position: "relative",
							left: "-10px",
							minWidth: "10px",
							height: "22px",
							padding: "0 10px",
						}}
						variant="text"
						size="medium"
						color="error"
					/>
				</>
			);
		} else {
			return (
				<MyButton
					text="详情"
					style={{
						position: "relative",
						left: "-10px",
						minWidth: "10px",
						height: "22px",
						padding: "0 10px",
					}}
					variant="text"
					size="medium"
					onClick={() => hanleToSeeEnv(item)}
				/>
			);
		}
	};

	return (
		<div className={style.environment}>
			<div className={style.top}>
				<div className={style.topLeft}>
					{!addOpen && (
						<SearchInput
							sx={{ width: 340, marginRight: "16px" }}
							onKeyUp={(e: any) => {
								if (e.keyCode === 13) {
									setTitle(e.target.value);
								}
							}}
						></SearchInput>
					)}
					{!addOpen && (
						<MySelect
							options={[
								{
									label: "全部环境",
									value: "ALL",
								},
								{
									label: "批式",
									value: "BATCH",
								},
								{
									label: "流式",
									value: "FLOW",
								},
							]}
							value={type}
							onChange={(e: any) => setType(e)}
							sx={{ width: "150px", height: "32px" }}
						></MySelect>
					)}
				</div>
				<div className={style.topRight}>
					<MyButton
						text="构建应用环境"
						onClick={() => setAddopen(true)}
						startIcon={<Add />}
					></MyButton>
				</div>
			</div>
			<div className={style.tableBox}>
				<MyTable
					rows={list.map((item: any) => ({
						...item,
						type: renderType(item),
						status: renderStatus(item),
						caozuo: renderButtons(item),
						createdTime: renderCreatedTime(item),
					}))}
					headCells={headCells}
					fixedHead={true}
					hasTableFooter={true}
					page={page}
					count={count}
					pageChange={pageChange}
					rowsPerPage={size}
					handleChangeRowsPerPage={(e: number) => {
						setSize(e);
						setPage(0);
					}}
					nodataText="暂无应用环境"
					paginationType="complex"
					totalElements={totalElements}
					loading={loading}
					sortState={sortState}
					setSortState={setSortState}
				></MyTable>
			</div>
			{addOpen && (
				<AddEnvironment
					setAddopen={setAddopen}
					setTitle={setTitle}
				></AddEnvironment>
			)}
			{deleteOpen && (
				<DeleteEnvironment
					id={id}
					open={deleteOpen}
					setDeleteOpen={setDeleteOpen}
				></DeleteEnvironment>
			)}
		</div>
	);
};

export default UserResourcesEnvironment;
