/*
 * @Author: 吴永生 15770852798@163.com
 * @Date: 2022-10-17 14:35:11
 * @LastEditors: 吴永生 15770852798@163.com
 * @LastEditTime: 2022-11-01 10:59:40
 * @FilePath: /bkunyun/src/views/ResourceCenter/UserResources/WorkflowOperator/index.tsx
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */

import { observer } from "mobx-react-lite";
import { useEffect, useMemo, useState } from "react";
import { useLocation, useNavigate } from "react-router-dom";
import { Base64 } from "js-base64";

import BasicInfo from "../../../../components/BasinInfo";
import RadioGroupOfButtonStyle from "@/components/CommonComponents/RadioGroupOfButtonStyle";
import useMyRequest from "@/hooks/useMyRequest";
import { getOperatorDetail } from "@/api/resourceCenter";
import { useStores } from "@/store";
import goback from "@/assets/project/goback.svg";
import Code from "@/components/CommonComponents/Code";
import Flow from "@/views/Project/components/Flow";
import { IParameterClassType, parameterClassType } from "../../interface";

import styles from "./index.module.css";

const ParametersInfo = (props: any) => {
	const {
		name = "",
		title = "",
		classType = "",
		parameterGroup = "",
		required,
		defaultValue,
		domType,
		description = "",
	} = props?.info;
	const infoData = useMemo(() => {
		return [
			{
				label: "参数标题",
				value: title,
			},
			{
				label: "参数类型",
				value: classType,
			},
			{
				label: "参数分类",
				value: parameterClassType[parameterGroup as IParameterClassType],
			},
			{
				label: "是否必填",
				value: Boolean(required) ? "是" : "否",
			},
			{
				label: "默认值",
				value: defaultValue,
			},
			{
				label: "输入类型",
				value: domType,
			},
			{
				label: "参数描述",
				value: description,
			},
		];
	}, [
		classType,
		defaultValue,
		description,
		domType,
		parameterGroup,
		required,
		title,
	]);
	return (
		<div className={styles.paramsBox}>
			<div className={styles.nameBox}>{name}</div>
			{infoData.map((item) => {
				return (
					<div key={item.label} className={styles.infoItem}>
						<b>{item.label}</b>
						<span>{item.value || "-"}</span>
					</div>
				);
			})}
		</div>
	);
};

const OperatorDetails = observer(() => {
	/** 产品store */
	const { productListStore } = useStores();
	const navigate = useNavigate();

	/** 详情类型 */
	const [contentType, setContentType] = useState<string>("flowChart");
	/** 详情数据 */
	const [detailData, setDetailData] = useState<any>({});
	/** 详情数据 */
	const [detailInfo, setDetailInfo] = useState<any>({});
	/** 获取算子详情 */
	const { run: fetchOperatorDetail } = useMyRequest(getOperatorDetail, {
		onSuccess: (res: any) => {
			if (res.message === "success") {
				/** 设置详情数据 */
				const newData = res.data.map((item: any) => {
					/** 初始化批算子偏移量 */
					if (item.type === "BATCH") {
						item.position = { x: 100, y: 100 };
					}
					return item;
				});
				setDetailData(newData);
				const filterData = res?.data?.filter((item: any) => {
					return item.type === "BATCH";
				});

				if (filterData?.length) {
					setDetailInfo(filterData[0]);
				} else {
					res?.data?.length && setDetailInfo(res.data[0]);
				}
			}
		},
	});
	const location = useLocation();
	const locationInfo: any = location?.state;

	const {
		title = "",
		version = "",
		productId = "",
		createdTime = "",
		creator = "",
		description = "",
		type,
		envName = "",
		envId,
		command,
	} = detailInfo;

	const contentTypeList = useMemo(() => {
		const result = [
			...(!envId ? [{ value: "flowChart", label: "流程图" }] : []),
			{ value: "parameterList", label: "参数列表" },
			...(envId ? [{ value: "runScript", label: "运行脚本" }] : []),
		];
		return result;
	}, [envId]);

	/** 初始设置第一项 */
	useEffect(() => {
		setContentType(contentTypeList[0].value);
	}, [contentTypeList]);

	/** 切换类型 */
	const handleRadio = (val: string) => {
		setContentType(val);
	};

	const productText = useMemo(() => {
		const result = productListStore.productList?.filter((item) => {
			return item.value === productId;
		});
		return result?.length ? result[0].label : "";
	}, [productListStore.productList, productId]);

	useEffect(() => {
		fetchOperatorDetail(locationInfo.id);
	}, [fetchOperatorDetail, locationInfo.id]);

	return (
		<div className={styles.detailsBox}>
			<div className={styles.titleBox}>
				<img
					className={styles.goBackIcon}
					src={goback}
					alt=""
					onClick={() =>
						navigate("/utility/resourceCenter/userResources", {
							state: { defaultTab: "USERRESOURCES_FLOE" },
						})
					}
				/>
				<div className={styles.title}>{title}</div>
				<div className={styles.type}>
					{type === "BATCH" ? "批算子" : "流算子"}
				</div>
			</div>
			<h2 className={styles.baseInfoBox}>基础信息</h2>
			<div
				style={{
					border: "1px solid #EBEDF0",
					marginBottom: type === "BATCH" ? undefined : "16px",
				}}
			>
				<BasicInfo
					infoList={[
						{ label: "所属产品", value: productText },
						{
							label: "创建时间",
							value: createdTime,
						},
						{ label: "创建人", value: creator },
						{ label: "算子版本", value: version },
						{ label: "应用环境", value: envName },
					]}
				/>

				<BasicInfo
					infoList={[{ label: "描述", value: description || "暂无描述" }]}
				/>
			</div>
			{type === "BATCH" ? (
				<div style={{ padding: "26px 0 16px 0" }}>
					<RadioGroupOfButtonStyle
						RadiosBoxStyle={{ width: 254 }}
						value={contentType}
						radioOptions={contentTypeList}
						handleRadio={handleRadio}
					/>
				</div>
			) : null}
			{contentType === "flowChart" && !envId ? (
				<div className={styles.contentBox}>
					<Flow tasks={detailData} showControls={false} />
				</div>
			) : null}
			{contentType === "parameterList" || type === "FLOW" ? (
				<>
					{detailInfo?.parameters?.map((item: any) => {
						return <ParametersInfo key={item.id} info={item} />;
					})}
				</>
			) : null}
			{contentType === "runScript" ? (
				<Code
					className={styles.contentBox}
					value={Base64.decode(command || "")}
					editable={false}
					height="100%"
				/>
			) : null}
		</div>
	);
});

export default OperatorDetails;
