import React, { FC } from "react";

import { Props } from "ahooks/lib/useControllableValue";
import { makeStyles } from "tss-react/mui";
import { Typography, Menu, MenuItem, IconButton, Button } from "@mui/material";
import { TextField } from '@mui/material';

import ArrowDropDownIcon from '@mui/icons-material/ArrowDropDown';
type selectData = {
    json: any[]
    native?: boolean
}

type resizeBysData = 'outlinedLarge' | 'outlined' | 'outlinedSmall' | 'outlinedXsmall' | 'MuiOutlinedInputInputLarge' | 'MuiOutlinedInputInput' | 'MuiOutlinedInputInputSmall' | 'MuiOutlinedInputInputXsmall'

// type b = 'selectPropsLarge' | 'selectPropsSmall' | 'selectPropsXsmall' 

type TextFieldProps = {
    label?: string
    autoFocus?: boolean
    type?: string
    defaultValue?: string
    placeholder?: string
    variant?: "outlined" | "standard" | "filled" | undefined
    select?: selectData
    disabled?: boolean
    onChange?: () => void;
    onBlur?: () => void;
    error?: boolean
    helperText?: string
    fullWidth?: boolean
    rows?: number
    multiline?: boolean
    required?: boolean
    onkeydown?: () => void;
    margin?: "none" | "dense" | undefined
    size?: string
    selectSize?: string
    selectStyle?: any
    startAdornment?: JSX.Element;
    endAdornment?: JSX.Element;
    disabledClass?: any
    textAlign?: 'right' | 'center' | 'left'
    customClass?: any
    value?: any
    onFocus?: () => void;
}

const InputComponent = (props: TextFieldProps) => {
    const { label, autoFocus, type, defaultValue, placeholder, variant, select, disabled, onChange, onBlur, error, helperText,
        fullWidth, rows, multiline, required, onkeydown, margin, size, selectSize, selectStyle, startAdornment, endAdornment,
        disabledClass, textAlign, customClass, value, onFocus
    } = props;
    const { classes, cx } = useStyles({});

    const onChangeDefault = () => { }
    const resizeBys = (sty: string) => {
        switch (size) {
            case "large":
                return sty + "Large";
            case "small":
                return sty + "Small";
            case "xsmall":
                return sty + "Xsmall";
            default:
                return sty;
        }
    }
    const reSelectSizeBys = (sty: string) => {
        switch (selectSize) {
            case "large":
                return sty + "Large";
            case "small":
                return sty + "Small";
            case "xsmall":
                return sty + "Xsmall";
            default:
                return sty;
        }
    }
    const onBlurDefault = () => {

    }
    const onFocusDefault = () => { }


    if (![undefined, null].includes(value)) {
        return (
            <TextField
                label={label || ""}
                autoFocus={autoFocus || false}
                type={type || "text"}
                value={value || ""}
                placeholder={placeholder || ""}
                variant={variant || "outlined"}
                select={select ? true : false}
                disabled={disabled || false}
                onChange={onChange || onChangeDefault}
                onBlur={onBlur || onBlurDefault}
                error={error || false}
                helperText={helperText || ""}
                fullWidth={fullWidth || false}
                onFocus={onFocus || onFocusDefault}
                rows={rows || 1}
                multiline={multiline || false}
                required={required || false}
                InputProps={{
                    margin: margin || "none",
                    classes: {
                        root: classes.root,
                        input: cx({
                            [classes[resizeBys("MuiOutlinedInputInput") as resizeBysData]]: true,
                            ...(textAlign ? { [classes[`SelectProps${textAlign}`]]: textAlign } : {}),
                            [customClass]: customClass
                        }),
                        // notchedOutline: classes.notchedOutline,
                        error: classes.error,
                        disabled: disabledClass || classes.disabled,
                        // adornedEnd: classes.adornedEnd
                    },
                    startAdornment: startAdornment || "",
                    endAdornment: endAdornment || ""
                }}
                InputLabelProps={{
                    classes: {
                        root: classes[resizeBys("outlined") as resizeBysData],
                        error: classes.errorLabel
                    }
                }}
                FormHelperTextProps={{
                    classes: {
                        error: classes.errorFormHelperTextProps
                    }
                }}
                SelectProps={{
                    native: (select && select.native) || false,
                    classes: {
                        outlined: textAlign ? classes[`SelectProps${textAlign}`] : classes['SelectPropsleft'],
                        // selectMenu: classes[reSelectSizeBys("selectProps") as b]
                    }
                }}
            >
                {
                    select && select.json && select.json.length > 0 && select.json.map((option: any, key) => {
                        return (
                            <MenuItem key={key} disabled={option.disabled || false} value={option.value} className={selectStyle || classes.defaultSelectStyle}>
                                {option.label}
                            </MenuItem>
                        )
                    })
                }
            </TextField>
        )
    }
    return (
        <TextField
            label={label || ""}
            autoFocus={autoFocus || false}
            type={type || "text"}
            defaultValue={defaultValue || ""}
            placeholder={placeholder || ""}
            variant={variant || "outlined"}
            select={select ? true : false}
            disabled={disabled || false}
            onChange={onChange || onChangeDefault}
            onBlur={onBlur || onBlurDefault}
            error={error || false}
            helperText={helperText || ""}
            fullWidth={fullWidth || false}
            rows={rows || 1}
            multiline={multiline || false}
            required={required || false}
            onKeyDown={onkeydown || (() => { })}
            InputProps={{
                margin: margin || "none",
                classes: {
                    root: classes.root,
                    input: cx({
                        [classes[resizeBys("MuiOutlinedInputInput") as resizeBysData]]: true,
                        ...(textAlign ? { [classes[`SelectProps${textAlign}`]]: textAlign } : {}),
                        [customClass]: customClass
                    }),
                    // notchedOutline: classes.notchedOutline,
                    error: classes.error,
                    disabled: disabledClass || classes.disabled,
                    // adornedEnd: classes.adornedEnd
                },
                startAdornment: startAdornment || "",
                endAdornment: endAdornment || ""
            }}
            InputLabelProps={{
                classes: {
                    root: classes[resizeBys("outlined") as resizeBysData],
                    error: classes.errorLabel
                }
            }}
            FormHelperTextProps={{
                classes: {
                    error: classes.errorFormHelperTextProps
                }
            }}
            SelectProps={{
                native: (select && select.native) || false,
                classes: {
                    outlined: textAlign ? classes[`SelectProps${textAlign}`] : classes['SelectPropsleft'],
                }
            }}
        >
            {
                select && select.json && select.json.length > 0 && select.json.map((option: any, key) => {
                    return (
                        <MenuItem key={key} disabled={option.disabled || false} value={option.value} className={selectStyle || classes.defaultSelectStyle}>
                            {option.label}
                        </MenuItem>
                    )
                })
            }
        </TextField>
    )

}

const useStyles = makeStyles<{}>()(
    (theme, { }) => ({
        MuiOutlinedInputInputLarge: { padding: "13.5px 15px !important", MozAppearance: 'textfield' },
        MuiOutlinedInputInput: { padding: "12px 15px !important", "&::placeholder": { fontSize: "14px" }, MozAppearance: 'textfield' },
        MuiOutlinedInputInputSmall: { padding: "10px 15px !important", "&::placeholder": { fontSize: "13px" }, MozAppearance: 'textfield' },
        MuiOutlinedInputInputXsmall: { padding: "8px 15px !important", "&::placeholder": { fontSize: "12px" }, MozAppearance: 'textfield' },
        outlinedLarge: { transform: "translate(14px, 15.5px) scale(1) ", fontSize: '14px !important', fontWeight: '400 !important', color: '#707070 !important' },
        outlined: { transform: "translate(14px, 14px) scale(1) ", fontSize: '14px !important', fontWeight: '400 !important', color: '#707070 !important' },
        outlinedSmall: { transform: "translate(14px, 11px) scale(1) ", fontSize: '14px !important', fontWeight: '400 !important', color: '#707070 !important' },
        outlinedXsmall: { transform: "translate(12px, 11px) scale(1) ", fontSize: '13px !important', fontWeight: '400 !important', color: '#707070 !important' },
        notchedOutline: { borderColor: "rgba(216, 216, 216, 1)" },
        root: {
            "&:hover": {
                "& .MuiOutlinedInput-notchedOutline": { borderColor: "rgba(19, 110, 250, 0.9)" }
            },
        },
        error: {
            "& .MuiOutlinedInput-notchedOutline": {
                borderColor: "#D62C1F !important"
            },
        },
        disabled: {
            color: "#E3E3E3 !important",
            "& .MuiOutlinedInput-notchedOutline": { borderColor: "#E3E3E3 !important" },
            "&:hover": {
                "& .MuiOutlinedInput-notchedOutline": { borderColor: "#E3E3E3 !important" }
            },
        },
        errorLabel: { color: "#D62C1F !important" },
        errorFormHelperTextProps: { color: "#D62C1F !important", fontSize: "12px", lineHeight: '14px' },
        SelectPropsright: { textAlign: "right" },
        SelectPropscenter: { textAlign: "center" },
        SelectPropsleft: { textAlign: "left" },
        selectProp: { fontSize: "14px" },
        selectPropsLarge: { fontSize: "14px" },
        selectPropsSmall: { fontSize: "13px" },
        selectPropsXsmall: { fontSize: "12px" },
        adornedEnd: { paddingRight: "8px" },
        defaultSelectStyle: { fontSize: "14px" }

    })
);


export default InputComponent;