import {
  Button,
  Dialog,
  DialogActions,
  DialogContent,
  IconButton,
  DialogTitle,
} from "@mui/material";
import LoadingButton from "@mui/lab/LoadingButton";
import CloseIcon from "@mui/icons-material/Close";

import { useState } from "react";
import { useImperativeHandle } from "react";
const MyDialog = (props: any) => {
  const [open, setOpen] = useState(false);
  const {
    title,
    handleSubmit,
    submitloading,
    submitStyle = { backgroundColor: "#1370FF" },
    showCloseButton = true,
    submitText = "确定",
  } = props;

  const handleClickOpen = () => {
    setOpen(true);
  };

  const handleClose = (event: any = {}, reason: any = "other") => {
    // 点击弹窗外不关闭弹窗
    if (reason === "backdropClick") {
      return;
    }
    setOpen(false);
  };

  useImperativeHandle(props.onRef, () => {
    return {
      handleClickOpen: handleClickOpen,
      handleClose: handleClose,
    };
  });

  return (
    <Dialog
      open={open}
      onClose={handleClose}
      className="aaa"
      aria-labelledby="form-dialog-title"
      sx={{
        "& .MuiDialog-container": {
          "& .MuiPaper-root": {
            // 设置最大宽度， 实际宽度让子元素撑大
            maxWidth: "1920px",
          },
        },
      }}
    >
      {title && (
        <DialogTitle id="form-dialog-title" sx={{ fontWeight: "600" }}>
          {title}
        </DialogTitle>
      )}
      <DialogContent
        sx={{
          minWidth: "400px",
        }}
      >
        {props.children}
        <IconButton
          aria-label="delete"
          style={{ position: "absolute", top: "10px", right: "12px" }}
          onClick={handleClose}
        >
          <CloseIcon style={{ color: "#C2C6CC" }} />
        </IconButton>
      </DialogContent>
      <DialogActions style={{ padding: "16px 24px" }}>
        {showCloseButton && (
          <Button
            onClick={handleClose}
            color="inherit"
            variant="contained"
            style={{ color: "#1E2633", backgroundColor: "#fff" }}
            size="small"
          >
            取消
          </Button>
        )}
        <LoadingButton
          loading={submitloading}
          onClick={handleSubmit}
          color="primary"
          variant="contained"
          style={submitStyle}
          size="small"
        >
          {submitText}
        </LoadingButton>
      </DialogActions>
    </Dialog>
  );
};

export default MyDialog;
