/*
 * @Author: 吴永生#A02208 yongsheng.wu@wholion.com
 * @Date: 2022-05-31 10:18:13
 * @LastEditors: 吴永生#A02208 yongsheng.wu@wholion.com
 * @LastEditTime: 2022-07-07 18:08:33
 * @FilePath: /bkunyun/src/views/Project/ProjectSetting/index.tsx
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import { memo, useCallback, useEffect, useMemo, useState } from "react";
import _ from "lodash";

import OutlinedInput from "@mui/material/OutlinedInput";
import { Box } from "@mui/material";
import Button from "@mui/material/Button";
import SearchIcon from "@mui/icons-material/Search";
import Add from "@mui/icons-material/Add";
import Table from "@/components/Material.Ui/Table";
import { IResponse, useHttp } from "@/api/http";
import RemoveItem from "./components/RemoveItem";
import ChangePermission from "./components/ChangePermission";
import AddMember from "./components/AddMember";

import styles from "./index.module.css";
import { IDialogInfo } from "./interface";
import { toJS } from "mobx";
import { useStores } from "@/store";
import { isProjectOwner } from "@/utils/util";
import { observer } from "mobx-react";

const ProjectMembers = observer(() => {
	const http = useHttp();

	const { currentProjectStore } = useStores();

	/** 删除成员 */
	const [removeDialog, setRemoveDialog] = useState<IDialogInfo>({
		isShow: false,
		username: "",
	});
	/** 更改权限 */
	const [permissionDialog, setPermissionDialog] = useState<IDialogInfo>({
		isShow: false,
		username: "",
	});
	/** 添加成员 */
	const [addMemberDialog, setAddMemberDialog] = useState<boolean>(false);
	/** 表格数据 */
	const [tableData, setTableData] = useState([]);
	/** 当前项目用户权限 */
	const [projectRole, setProjectRole] = useState<string>("");
	/** 项目名称 */
	const [projectName, setProjectMember] = useState("");
	/** 过滤后数据 */
	const [filterTableData, setFilterTableData] = useState([]);

	const columns = useMemo(() => {
		const val: any = [
			{ id: "username", label: "成员名称" },
			{ id: "projectRoleDesc", label: "项目权限" },
			{ id: "phone", label: "联系方式" },
			...(projectRole !== "OWNER"
				? []
				: [
						{
							id: "operation",
							label: "操作",
							width: 160,
							render: (item: any, row: any) => {
								return row?.projectRole === "OWNER" ? null : (
									<>
										<span
											style={{ color: "#1370FF", cursor: "pointer" }}
											onClick={() => {
												onPermissionBtn(row);
											}}
										>
											更改权限
										</span>
										<span
											className={styles.removeItemBox}
											onClick={() => {
												onRemoveItemBtn(row.username);
											}}
										>
											移出项目
										</span>
									</>
								);
							},
						},
				  ]),
		];
		return val;
	}, [projectRole]);

	/** 获取表格数据 */
	const getTableList = useCallback(() => {
		const projectInfo = toJS(currentProjectStore?.currentProjectInfo);
		if (!projectInfo?.id) return;
		http
			.get<IResponse<any>>("/cpp/project/get", {
				params: { id: projectInfo?.id || "" },
			})
			.then((res) => {
				const { data = {} } = res;
				setTableData(data?.members || []);
				console.log(data?.projectRole, data?.projectRole);
				setProjectRole(data?.projectRole || "");
			});
	}, [currentProjectStore?.currentProjectInfo, http]);

	useEffect(() => {
		getTableList();
	}, [getTableList]);

	useEffect(() => {
		if (!!projectName) {
			const newVal =
				tableData.filter((item: any) => {
					return item?.username?.includes(projectName);
				}) || [];
			setFilterTableData(newVal || []);
		} else {
			setFilterTableData(tableData);
		}
	}, [projectName, tableData]);

	/** 点击添加成员 */
	const onAddMember = () => {
		setAddMemberDialog(true);
	};

	/** 点击删除成员 */
	const onRemoveItemBtn = (userName: string) => {
		setRemoveDialog({ isShow: true, username: userName });
	};

	/** 点击更改权限 */
	const onPermissionBtn = (row: any) => {
		setPermissionDialog({
			isShow: true,
			username: row?.username || "",
			projectRole: row?.projectRole || "",
		});
	};

	return (
		<>
			<Box className={styles.headerBox}>
				<OutlinedInput
					onChange={(e: any) => {
						_.debounce(() => {
							setProjectMember(e.target.value);
						}, 200)();
					}}
					placeholder="搜索项目成员"
					size="small"
					sx={{ width: 340, height: 32 }}
					endAdornment={<SearchIcon style={{ color: "#8A9099" }} />}
				/>
				{currentProjectStore?.currentProjectInfo?.projectRole === "OWNER" ? (
					<Button
						style={{ backgroundColor: "#1370FF " }}
						variant="contained"
						onClick={onAddMember}
						startIcon={<Add />}
						size="small"
					>
						添加成员
					</Button>
				) : null}
			</Box>
			<Table
				rowHover={true}
				stickyheader={true}
				rows={filterTableData}
				rowsPerPage={"99"}
				headCells={columns}
				nopadding={true}
				footer={false}
				tableStyle={{ minWidth: "auto" }}
				borderBottom={"none"}
			/>
			<RemoveItem
				removeDialog={removeDialog}
				setRemoveDialog={setRemoveDialog}
				getTableList={getTableList}
			/>
			<ChangePermission
				permissionDialog={permissionDialog}
				getTableList={getTableList}
				setPermissionDialog={setPermissionDialog}
			/>
			<AddMember
				addMemberDialog={addMemberDialog}
				setAddMemberDialog={setAddMemberDialog}
				getTableList={getTableList}
			/>
		</>
	);
});

export default memo(ProjectMembers);
