/*
 * @Author: 吴永生#A02208 yongsheng.wu@wholion.com
 * @Date: 2022-07-12 11:29:46
 * @LastEditors: 吴永生 15770852798@163.com
 * @LastEditTime: 2022-08-08 18:43:35
 * @FilePath: /bkunyun/src/views/Project/components/Flow/components/FlowNode/index.tsx
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import classNames from "classnames";
import { Handle, Position } from "react-flow-renderer";
import { useMemo } from "react";
// import { IParameter } from "@/views/Project/ProjectSubmitWork/interface";
import { uuid } from "@/utils/util";

import { IExecutionStatus } from "@/views/Project/ProjectSubmitWork/interface";
import jobFail from "@/assets/project/jobFail.svg";
import jobRun from "@/assets/project/jobRun.svg";
import jobSue from "@/assets/project/jobSue.svg";
import MyTooltip from "@/components/mui/MyTooltip";

import styles from "./index.module.css";
/** 自定义flow节点 */
const FlowNode = (props: any) => {
	/** 获取imgUrl */
	const getImgUrl = (type: IExecutionStatus) => {
		if (type === "Done") {
			return jobSue;
		}
		if (type === "Failed") {
			return jobFail;
		}
		if (type === "Running") {
			return jobRun;
		}
		return undefined;
	};

	const { data } = props;
	const {
		dotStatus,
		selectedStatus,
		flowNodeStyle = { display: "flex", alignItems: "center" }, // 样式
		inStyle = { background: "#C2C6CC ", left: 12 }, // 样式
		outStyle = { background: "#C2C6CC ", left: 12 }, // 样式
		flowType,
		info: { title, isCheck, executionStatus, parameters },
	} = data;

	/** 获取输入参数数组 */
	const inParamsArr = useMemo(() => {
		return (
			(parameters?.length &&
				parameters?.filter((item: any) => {
					return item.parameterGroup === "in";
				})) ||
			[]
		);
	}, [parameters]);

	/** 获取输出参数数组 */
	const outParamsArr = useMemo(() => {
		return (
			(parameters?.length &&
				parameters?.filter((item: any) => {
					return item.parameterGroup === "out";
				})) ||
			[]
		);
	}, [parameters]);
	return (
		<div
			style={flowNodeStyle}
			className={classNames({
				[styles.flowNode]: true,
				[styles.selectedFlowBox]: selectedStatus,
			})}
		>
			{dotStatus?.isInput ? (
				<Handle style={inStyle} type="target" position={Position.Top} />
			) : null}
			{inParamsArr?.length
				? inParamsArr.map((item: any, index: number) => {
						return (
							<MyTooltip title={item.name} key={uuid()}>
								<Handle
									id={item.name}
									style={{
										background: "#fff ",
										border: "1px solid #D1D6DE",
										left: index * 20 + 20,
										...inStyle,
									}}
									type="target"
									position={Position.Top}
								/>
							</MyTooltip>
						);
				  })
				: null}
			<div>
				{title || ""}
				{flowType !== 'edit' && isCheck ? <span className={styles.successDot}></span>: null}
				{flowType === 'edit' && isCheck === false ? <span className={styles.errorDot}></span>: null}
				{getImgUrl(executionStatus) && (
					<img
						style={{ marginLeft: "6px" }}
						src={getImgUrl(executionStatus)}
						alt=""
					/>
				)}
			</div>
			{dotStatus?.isOutput ? (
				<Handle style={outStyle} type="source" position={Position.Bottom} />
			) : null}
			{outParamsArr?.length
				? outParamsArr.map((item: any, index: number) => {
						return (
							<MyTooltip title={item.name} key={uuid()}>
								<Handle
									id={item.name}
									style={{
										background: "#fff ",
										border: "1px solid #D1D6DE",
										left: index * 20 + 20,
										...outStyle,
									}}
									type="source"
									position={Position.Bottom}
								/>
							</MyTooltip>
						);
				  })
				: null}
		</div>
	);
};

export default FlowNode;
