import request from "@/utils/axios/service";
import Api from "./api_manager";

function current() {
  return request({
    url: Api.API_USER_FETCH,
    method: "get",
  });
}

function menu() {
  return request({
    url: "/accounts/menu-mock",
    method: "get",
  });
}

type projectListParams = {
  product: string;
  name?: string;
};

// 查询当前用户可以看到的项目列表
const getProjectList = (params: projectListParams) => {
  return request({
    url: Api.API_PROJECT_LIST,
    method: "get",
    params,
  });
};

type addProjectParams = {
  product: string;
  name: string;
  zoneId: string;
  desc?: string;
};
// 新增项目
const addProject = (params: addProjectParams) => {
  return request({
    url: Api.API_PROJECT_ADD,
    method: "post",
    data: params,
  });
};

// 获取计算区列表
const hpczone = () => {
  return request({
    url: Api.API_CPCE_HPCZONE,
    method: "get",
  });
};

type getProjectParams = {
  id: string;
};

// 获取项目信息
const getProject = (params: getProjectParams) => {
  return request({
    url: Api.API_PROJECT_GET,
    method: "get",
    params,
  });
};

// 修改项目信息
const updateProject = (params: addProjectParams) => {
  return request({
    url: Api.API_PROJECT_UPDATE,
    method: "put",
    data: params,
  });
};

type deleteProjectParams = {
  id: string;
};

// 删除项目
const deleteProject = (params: deleteProjectParams) => {
  return request({
    url: Api.API_PROJECT_DELETE,
    method: "delete",
    params,
  });
};

type getDataFileTokenParams = {
  id: string;
};
// 获取项目目录的filetoken
const getDataFileToken = (params: getDataFileTokenParams) => {
  return request({
    url: Api.API_DATA_FILETOKEN,
    method: "get",
    params,
  });
};

type getDataFindParams = {
  projectId: string;
  path: string;
};

// 查询某路径下数据集
const getDataFind = (params: getDataFindParams) => {
  return request({
    url: Api.API_DATA_FIND,
    method: "get",
    params,
  });
};

type getDataFileSearchParams = {
  projectId: string;
  name: string;
  path?: string;
};

// 搜索项目中某路径下的数据集
const getDataFileSearch = (params: getDataFileSearchParams) => {
  return request({
    url: Api.API_DATA_SEARCH,
    method: "get",
    params,
  });
};

type getDataFileMoveParams = {
  projectId: string;
  names: string;
  spath?: string; // 原路径
  dpath?: string; // 目标路径
};

// 移动到
const getDataFileMove = (params: getDataFileMoveParams) => {
  return request({
    url: Api.API_DATA_MOVE,
    method: "put",
    data: params,
    headers: {
      "Content-Type": "application/x-www-form-urlencoded",
    },
  });
};

type getDataFileMovePackageParams = {
  projectId: string;
  // names: string; // 包名
  packageNames: string; // 数据集之外的包名  ','分隔
  dataSetNames: string; // 数据集包名 ','分隔
  spath?: string; // 原路径
  dpath?: string; // 目标路径
};

// 移动文件夹中的数据集
const getDataFileMovePackage = (params: getDataFileMovePackageParams) => {
  return request({
    url: Api.API_DATA_MOVE_PACKAGE,
    method: "put",
    data: params,
    headers: {
      "Content-Type": "application/x-www-form-urlencoded",
    },
  });
};

type getDataFileDelParams = {
  projectId: string;
  names: string;
  path?: string;
};

// 删除项目中的数据集
const getDataFileDel = (params: getDataFileDelParams) => {
  return request({
    url: Api.API_DATA_DEL,
    method: "delete",
    params,
    headers: {
      "Content-Type": "application/x-www-form-urlencoded",
    },
  });
};

type getDataFileDelPackageParams = {
  projectId: string;
  packageNames: string; // 数据集之外的包名  ','分隔
  dataSetNames: string; // 数据集包名 ','分隔
  path?: string;
};

// 删除项目中的数据集
const getDataFileDelPackage = (params: getDataFileDelPackageParams) => {
  return request({
    url: Api.API_DATA_DEL_PACKAGE,
    method: "delete",
    params,
    headers: {
      "Content-Type": "application/x-www-form-urlencoded",
    },
  });
};

// 点击使用模版，获取模版数据
const fetchTemplateConfigInfo = (params: { id: string }) => {
  return request({
    url: `${Api.API_FETCH_TEMPLATE_INFO}/${params.id}`,
    method: "get",
  });
};

// 点击工作列表，查看工作流详情
const fetchWorkFlowJob = (params: { id: string }) => {
  return request({
    url: `${Api.API_WORK_FLOW_JOB}/${params.id}`,
    method: "get",
  });
};

type submitWorkFlowParams = {
  name: string;
  projectId: string;
  specId: string;
  outputPath: string;
  promotedParameters: any;
};

// 提交工作流
const submitWorkFlow = (params: submitWorkFlowParams) => {
  return request({
    url: Api.API_SUBMIT_WORKFLOW,
    method: "post",
    data: params,
  });
};

// 查询任务某个算子详情
const getworkFlowTaskInfo = (params: { jobId: string; taskId: string }) => {
  return request({
    url: `${Api.API_WORKBENCH_WORKFLOW_TASKINFO}?jobId=${params.jobId}&taskId=${params.taskId}`,
    method: "get",
  });
};

//获取概览基本信息
const getOverviewInfo=(params: { id: string })=>{
  return request({
    url:`${Api.API_OVERVIEW_GET}/${params.id}`,
    method:"get",
  })
}

//获取任务概览
type getTaskOverviewParams = {
  projectId: string;
  jobName?: string;
  day?: number;
  page?: number;
  size?: number;
};
const getTaskOverview=(params:getTaskOverviewParams)=>{
  return request({
    url:Api.API_TASK_OVERVIEW_LIST,
    method:"get",
    params,
  })
}

// 获取流算子列表，可用于模糊查询，返回所有版本流算子
type getOperatorListParams = {
  productId: string;
  keyword?: string;
  page?: number;
  size?: number;
};
const getOperatorList=(params:getOperatorListParams)=>{
  return request({
    url:Api.API_OPERATOR_LISTSTREAMACTORS,
    method:"get",
    params,
  })
}

type saveBatchQuery = {
  productId: string;
  batchName: string;
  batchVersion: string;
  description?: string;
  isEdit?: string;
}
type saveBatchBody = Array<any>

type saveBatchParams = {
  query: saveBatchQuery;
  body: saveBatchBody;
}

// 提交工作流
const saveBatchActor = (params: saveBatchParams) => {
  return request({
    url: Api.API_SAVE_BATCHACTOR,
    method: "post",
    params: params.query,
    data: params.body,
  });
};

export {
  current,
  menu,
  getProjectList,
  hpczone,
  addProject,
  getProject,
  updateProject,
  deleteProject,
  getDataFileToken,
  getDataFind,
  getDataFileSearch,
  getDataFileMove,
  getDataFileMovePackage,
  getDataFileDel,
  getDataFileDelPackage,
  fetchTemplateConfigInfo,
  fetchWorkFlowJob,
  submitWorkFlow,
  getworkFlowTaskInfo,
  getOverviewInfo,
  getTaskOverview,
  getOperatorList,
  saveBatchActor
};
