/*
 * @Author: 吴永生#A02208 yongsheng.wu@wholion.com
 * @Date: 2022-05-31 10:18:13
 * @LastEditors: 吴永生 15770852798@163.com
 * @LastEditTime: 2022-08-10 11:06:12
 * @FilePath: /bkunyun/src/views/Project/ProjectSetting/index.tsx
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import { memo } from "react";
import { isEqual } from "lodash";
import { useState } from "react";
import { Box } from "@mui/system";
import Tab from "@mui/material/Tab";
import { ThemeProvider, createTheme } from "@mui/material/styles";
import { TabContext, TabList, TabPanel } from "@mui/lab";
import { Typography } from "@mui/material";

interface ITabList {
	label: string;
	value: string;
	component: JSX.Element | React.ReactNode;
	icon?: string;
	iconed?: string;
	hide?: boolean;
	disabled?: boolean;
}

interface IProps {
	tabList: ITabList[];
	defaultValue?: string;
	tabPanelSx?: any;
	allowNullValue?: boolean; // 是否允许空值
}

const theme = createTheme({
	components: {
		MuiTab: {
			styleOverrides: {
				root: {
					paddingLeft: 0,
					paddingRight: 0,
					paddingTop: "8px",
					paddingBottom: "8px",
					minWidth: "20px",
					marginRight: "32px",
					color: "#8A9099",
					":hover": {
						color: "#1E2633",
					},
					selected: {
						color: "#1976d2",
					},
					"&.Mui-disabled": {
						color: "#C2C6CC",
					},
				},
			},
		},
		// #C2C6CC
		MuiTabs: {
			styleOverrides: {
				indicator: {
					backgroundColor: "#1370FF",
				},
			},
		},
	},
});

const Tabs = (props: IProps) => {
	const {
		tabList,
		defaultValue,
		allowNullValue = false,
		tabPanelSx = { padding: "24px 0 0 0" },
	} = props;
	const [value, setValue] = useState(
		defaultValue
			? defaultValue
			: allowNullValue
			? ""
			: tabList.filter((e) => !e.hide)[0].value
	);

	const onChange = (val: string) => {
		setValue(val);
	};

	const labelRender = (item: ITabList, key: number) => {
		return (
			<Box style={{ display: "flex", alignItems: "center" }}>
				{item.icon ? (
					<img
						style={{ width: "16px", marginRight: "8px" }}
						src={value === item.value ? item.iconed : item.icon}
						alt=""
					/>
				) : (
					""
				)}
				<Typography
					sx={{
						fontSize: "14px",
						lineHeight: "22px",
						height: "22px",
						fontWeight: "400",
					}}
				>
					{item.label}
				</Typography>
			</Box>
		);
	};

	return (
		<ThemeProvider theme={theme}>
			<TabContext value={value}>
				<Box sx={{ borderBottom: 1, borderColor: "#EDEFF2" }}>
					<TabList
						onChange={(e: any, val: string) => {
							onChange(val);
						}}
					>
						{tabList
							?.filter((item) => !item.hide)
							.map((item, key) => {
								return (
									<Tab
										key={key}
										label={labelRender(item, key)}
										value={item.value || ""}
										id={item.value}
										disabled={item.disabled}
									/>
								);
							})}
					</TabList>
				</Box>
				{tabList
					?.filter((item) => !item.hide)
					.map((item) => {
						return (
							<TabPanel
								sx={tabPanelSx}
								value={item.value || ""}
								key={item.value}
							>
								{item.component}
							</TabPanel>
						);
					})}
			</TabContext>
		</ThemeProvider>
	);
};
const handleEqual = (prvProps: IProps, nextProps: IProps) => {
	if (isEqual(prvProps, nextProps)) {
		return true;
	}
	return false;
};

export default memo(Tabs, handleEqual);
