import React from "react";
import ReactDOM from "react-dom/client";
import "./index.css";
import reportWebVitals from "./reportWebVitals";
import MyRouter from "@/components/MyRouter";
import { Provider } from "mobx-react";
import { stores } from "@/store/index";
import { MySnackbarProvider } from "@/components/MySnackbar";
import "@/mocks/index";
import "./assets/style/public.css";
import { createTheme, ThemeProvider } from "@mui/material/styles";

const root = ReactDOM.createRoot(
	document.getElementById("root") as HTMLElement
);

const theme = createTheme({
	typography: {
		fontFamily: [
			"Roboto",
			"Helvetica",
			"Tahoma",
			"Arial",
			'"PingFang SC"',
			'"Hiragino Sans GB"',
			'"Heiti SC"',
			'"WenQuanYi Micro Hei"',
			"sans-serif",
			'"Apple Color Emoji"',
			'"Segoe UI Emoji"',
			'"Segoe UI Symbol"',
		].join(","),
	},
	palette: {
		primary: { main: "#136EFA" },
		secondary: { main: "#F44335" },
	},
});

root.render(
	<React.StrictMode>
		<ThemeProvider theme={theme}>
			<Provider {...stores}>
				<MySnackbarProvider
					alertSx={{ boxShadow: "0px 2px 4px 0px rgb(0 0 0 / 8%)" }}
				>
					<MyRouter></MyRouter>
				</MySnackbarProvider>
			</Provider>
		</ThemeProvider>
	</React.StrictMode>
);

// If you want to start measuring performance in your app, pass a function
// to log results (for example: reportWebVitals(console.log))
// or send to an analytics endpoint. Learn more: https://bit.ly/CRA-vitals
reportWebVitals();
