import logo from "@/assets/project/projectIcon.svg";
import style from "./index.module.css";
import ArrowForwardIosIcon from "@mui/icons-material/ArrowForwardIos";
import { Popper, Fade } from "@mui/material";
import { useStores } from "@/store/index";
import ProjectListPopper from "../ProjectListPopper";
import React, { useEffect, useState } from "react";
import { observer } from "mobx-react-lite";
import AddProject from "../AddProject";
import {
	setFileServerEndPointLocalStorage,
	getFiletokenAccordingToId,
} from "@/views/Project/project";

const CurrentProject = observer(() => {
	const { currentProjectStore } = useStores();
	const [projectListOpen, setProjectListOpen] = useState(false);
	const [anchorEl, setAnchorEl] = useState<null | HTMLElement>(null);

	useEffect(() => {
		document.addEventListener("click", (e) => {
			setProjectListOpen(false);
		});
		return () => {
			document.removeEventListener("click", (e) => {
				setProjectListOpen(false);
			});
		};
	}, []);

	const handleShowProjectList = (event: React.MouseEvent<HTMLElement>) => {
		event.nativeEvent.stopImmediatePropagation();
		setAnchorEl(event.currentTarget);
		setProjectListOpen((previousOpen) => !previousOpen);
	};
	const canBeOpen = projectListOpen && Boolean(anchorEl);
	const id = canBeOpen ? "spring-popper" : undefined;
	const handleChangeCurrentProject = (project: any) => {
		currentProjectStore.changeProject(project);
		setFileServerEndPointLocalStorage(project.zoneId);
		getFiletokenAccordingToId(project.id).then((res) => {
			project.filetoken = res;
			currentProjectStore.changeProject(project);
		});
		setProjectListOpen(!projectListOpen);
	};

	const openAddProject = () => {
		setAddOpen(true);
		setProjectListOpen(false);
	};

	// 新建弹窗显示控制
	const [addOpen, setAddOpen] = useState(false);

	return (
		<div>
			<div
				className={style.currentProject}
				aria-describedby={id}
				onClick={handleShowProjectList}
			>
				<img src={logo} alt="" className={style.logo} />
				<div className={style.info}>
					<div className={style.productName}>
						{currentProjectStore.currentProductInfo.name}
					</div>
					<div
						className={style.projectName}
						title={currentProjectStore.currentProjectInfo.name}
					>
						{currentProjectStore.currentProjectInfo.name || "暂无项目"}
					</div>
				</div>
				<ArrowForwardIosIcon
					className={style.showProjectList}
					style={{ fontSize: 12 }}
				/>
			</div>
			<AddProject addOpen={addOpen} setAddOpen={setAddOpen} />
			<Popper
				id={id}
				open={projectListOpen}
				anchorEl={anchorEl}
				placement="right-start"
				transition
				style={{ zIndex: 100 }}
			>
				{({ TransitionProps }) => (
					<Fade {...TransitionProps} timeout={350}>
						<div>
							<ProjectListPopper
								setProjectListOpen={setProjectListOpen}
								handleClickOpen={openAddProject}
								handleChangeCurrentProject={handleChangeCurrentProject}
							/>
						</div>
					</Fade>
				)}
			</Popper>
		</div>
	);
});

export default CurrentProject;
