/*
 * @Author: 吴永生#A02208 yongsheng.wu@wholion.com
 * @Date: 2022-07-11 11:56:58
 * @LastEditors: 吴永生 15770852798@163.com
 * @LastEditTime: 2022-09-08 13:55:20
 * @FilePath: /bkunyun/src/components/mui/MyTooltip.tsx
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import { Tooltip, TooltipProps } from "@mui/material";
import { ThemeProvider, createTheme } from "@mui/material/styles";

interface IMyTooltipProps extends Omit<TooltipProps, "title"> {
	title?: string | boolean;
}

const theme = createTheme({
	components: {
		MuiTooltip: {
			styleOverrides: {
				tooltip: {
					backgroundColor: "rgba(7, 19, 38, .8)",
					color: "#fff",
				},
				arrow: {
					"&:before": {
						backgroundColor: "#071326",
						opacity: "0.8",
					},
				},
			},
		},
	},
});

const MyTooltip = (props: IMyTooltipProps) => {
	const { title = false, children, placement = "top", ...other } = props;
	return (
		<ThemeProvider theme={theme}>
			<Tooltip
				// interactive={true}
				arrow
				title={title || ''}
				placement={placement}
				{...other}
			>
				{children}
			</Tooltip>
		</ThemeProvider>
	);
};

export default MyTooltip;
