import { useState } from "react";
import MyButton from "@/components/mui/MyButton";
import { sortState } from "@/components/mui/MyTableNew";
import MyTable from "@/components/mui/MyTableNew";

const MyTableDemo = () => {
	const [page, setPage] = useState(0);
	const [count, setCount] = useState(5);
	const [rowsPerPage, setRowsPerPage] = useState(10);
	const pageChange = (value: number) => {
		setPage(value - 1);
	};
	const [sortState, setSortState] = useState<sortState>({
		field: "",
		order: "",
	});

	const rows = [
		{
			a: "as123",
			b: "werewrw",
			c: "asdfasf",
			d: "asdfasdf",
			e: "asd4534",
			id: "1",
		},
		{
			a: "asdf",
			b: "asdg",
			c: "asdasdffasf",
			d: "sfgh",
			e: "asdgshdsdfh534",
			id: "2",
		},
		{
			a: "dfgj",
			b: "xcvb",
			c: "xcvb",
			d: "xcvb",
			e: "ert",
			id: "3",
		},
		{
			a: "xcgh",
			b: "sdf",
			c: "sdfg",
			d: "sdfg",
			e: "wertwe",
			id: "4",
		},
		{
			a: "as123",
			b: "werewrw",
			c: "asdfasf",
			d: "asdfasdf",
			e: "asd4534",
			id: "5",
		},
		{
			a: "asdf",
			b: "asdg",
			c: "asdasdffasf",
			d: "sfgh",
			e: "asdgshdsdfh534",
			id: "6",
		},
		{
			a: "dfgj",
			b: "xcvb",
			c: "xcvb",
			d: "xcvb",
			e: "ert",
			id: "7",
		},
		{
			a: "xcgh",
			b: "sdf",
			c: "sdfg",
			d: "sdfg",
			e: "wertwe",
			id: "8",
		},
		{
			a: "as123",
			b: "werewrw",
			c: "asdfasf",
			d: "asdfasdf",
			e: "asd4534",
			id: "9",
		},
		{
			a: "asdf",
			b: "asdg",
			c: "asdasdffasf",
			d: "sfgh",
			e: "asdgshdsdfh534",
			id: "10",
		},
		{
			a: "dfgj",
			b: "xcvb",
			c: "xcvb",
			d: "xcvb",
			e: "ert",
			id: "11",
		},
		{
			a: "xcgh",
			b: "sdf",
			c: "sdfg",
			d: "sdfg",
			e: "wertwe",
			id: "12",
		},
	];
	const buttonHeadCells = [
		{
			id: "a",
			label: "属性a",
			width: "25%",
		},
		{
			id: "b",
			label: "属性b",
			width: "25%",
		},
		{
			id: "c",
			label: "属性c",
			width: "25%",
		},
		{
			id: "d",
			label: "属性d",
			width: "25%",
		},
		{
			id: "caozuo",
			label: "操作",
			width: "25%",
		},
	];

	const headCells = [
		{
			id: "a",
			label: "属性a",
			width: "25%",
		},
		{
			id: "b",
			label: "属性b",
			width: "25%",
		},
		{
			id: "c",
			label: "属性c",
			width: "25%",
		},
		{
			id: "d",
			label: "属性d",
			width: "25%",
		},
	];

	const sortHeadCells = [
		{
			id: "a",
			label: "属性a",
			width: "25%",
			sort: true,
		},
		{
			id: "b",
			label: "属性b",
			width: "25%",
			sort: true,
		},
		{
			id: "c",
			label: "属性c",
			width: "25%",
		},
		{
			id: "d",
			label: "属性d",
			width: "25%",
		},
	];

	const [selectItems, setSelectItems] = useState(["1"]);
	const handleDelete = (e: string) => {
		console.log(e);
	};

	console.log(selectItems);
	return (
		<div>
			<h2>常规表格</h2>
			<div>
				<MyTable
					// rows={rows.map((row) => {
					// 	return {
					// 		...row,
					// 		caozuo: (
					// 			<MyButton
					// 				text="删除"
					// 				onClick={() => {
					// 					handleDelete(row.id);
					// 				}}
					// 			></MyButton>
					// 		),
					// 	};
					// })}
					rows={[]}
					headCells={buttonHeadCells}
					selectItems={selectItems}
					setSelectItems={setSelectItems}
				/>
			</div>
			<h2>有复选框表格</h2>
			<div>
				<MyTable
					rows={rows}
					headCells={headCells}
					hasCheckbox={true}
					selectItems={selectItems}
					setSelectItems={setSelectItems}
				/>
			</div>
			<h2>固定表头(需要指定每列宽度 不然对不齐)表格，内容滚动, </h2>
			<div style={{ height: "300px" }}>
				<MyTable
					rows={rows}
					headCells={headCells}
					hasCheckbox={true}
					selectItems={selectItems}
					setSelectItems={setSelectItems}
					fixedHead={true}
				/>
			</div>
			<h2>带分页的表格</h2>
			<div>
				<MyTable
					rows={rows}
					headCells={headCells}
					hasCheckbox={true}
					selectItems={selectItems}
					setSelectItems={setSelectItems}
					hasTableFooter={true}
					page={page}
					count={count}
					pageChange={pageChange}
					paginationType={"complex"}
					rowsPerPage={rowsPerPage}
					handleChangeRowsPerPage={setRowsPerPage}
					totalElements={12}
				/>
			</div>
			<h2>带分页且固定表头(需要指定每列宽度 不然对不齐)的表格</h2>
			<div style={{ height: "300px" }}>
				<MyTable
					rows={rows}
					headCells={headCells}
					hasCheckbox={true}
					selectItems={selectItems}
					setSelectItems={setSelectItems}
					fixedHead={true}
					hasTableFooter={true}
					page={page}
					count={count}
					pageChange={pageChange}
				/>
			</div>

			<h2>
				带排序表格(headCells中sort为true， 传入sortState、setSortState字段)
			</h2>
			<div>
				<MyTable
					rows={rows}
					headCells={sortHeadCells}
					selectItems={selectItems}
					setSelectItems={setSelectItems}
					sortState={sortState}
					setSortState={setSortState}
				/>
			</div>
		</div>
	);
};

export default MyTableDemo;
