import React, { useState, useEffect } from "react";
import Selectzone from './Selectzone.jsx'
import { Grid, Typography, List, ListItem, ListItemText } from '@mui/material';
import { makeStyles } from "@mui/styles";
import ArrowDropDownIcon from '@mui/icons-material/ArrowDropDown';
import cx from "classnames"
const useStyles = makeStyles({
    wrapHeightLarge: { height: "44px" },
    wrapHeight: { height: "40px" },
    wrapHeightSmall: { height: "36px" },
    wrapHeightXsmall: { height: "32px" },
    wrap: { width: "100%", position: "relative" },
    noBorderwrap: { width: "125px", position: "relative" },
    noBorderEnwrap: { width: "165px", position: "relative" },
    inputWrap: {
        display: "flex", justifyContent: "space-between", alignItems: "center", background: "#FFFFFF", borderRadius: '4px', border: "1px solid #D8D8D8",
        cursor: "pointer", padding: "0 15px",
        "&:hover": { borderColor: "#136EFA" }
    },
    noBorderinputWrap: {
        display: "flex", justifyContent: "space-between", alignItems: "center", background: "#FFFFFF",
        cursor: "pointer", padding: "0",
    },
    inputHeightLarge: { height: "44px" },
    inputHeight: { height: "40px" },
    inputHeightSmall: { height: "36px" },
    inputHeightXsmall: { height: "32px" },
    inputWrapOpen: { border: "1px solid #136EFA" },
    text: { color: "#1B1B1B", fontSize: '14px', fontWeight: 400 },
    ArrowDropDownIconRoot: { transition: "all 0.2s", transform: "rotate(0)" },
    ArrowDropDownIconRootOpen: { transform: "rotate(180deg)" },
    contentWrap: {
        padding: "8px 0", height: 0, transition: "all 1s", position: "absolute", zIndex: 9, width: "100%",
        backgroundColor: "#FFFFFF", boxShadow: "0px 2px 3px 0px rgba(0, 0, 0, 0.16)", borderRadius: "4px",
        overflowY: "overlay",
        maxHeight: "400px"
    },
    contentWrapOpen: { height: "auto" },
    rootListItem: { width: "100%", paddingRight: "0px" },
    root: { flex: '1 1 auto', minWidth: 0, color: '#222', marginTop: '4px', marginBottom: '4px' },
    primary: { fontSize: "14px" },
    lg: { fontSize: "16px" },
    sm: { fontSize: "13px" },
    md: { fontSize: "12px" },
    selected: {
        // background:'red',
        // color:'red'
    }
})
export default props => {
    const classes = useStyles();
    const { value, size, option, callback, noBorder, rootStyle, customSvg, textStyle, sz, startIcon, DropdownboxStyle, DropdownboxitemStyle } = props;
    const [open, setOpen] = useState(false)
    const [values, setValue] = useState(value || '请选择')
    const handleClick = (event) => {
        event.stopPropagation()
        setOpen((open) => !open)
    }
    const handleMouseUp = (event) => {
        setOpen(false)
        event && event.stopPropagation()
    }
    useEffect(() => {
        window.addEventListener('click', handleMouseUp, false)
        return () => window.removeEventListener('click', handleMouseUp, false)
    }, [])
    useEffect(() => {
        setValue(value)
    }, [value])
    const selectClick = (event, item) => {
        setValue(item.label)
        callback && callback(item)
        handleMouseUp()
        event.stopPropagation()
    }
    const resizeBys = (sty) => {
        switch (size) {
            case "large":
                return sty + "Large";
            case "small":
                return sty + "Small";
            case "xsmall":
                return sty + "Xsmall";
            default:
                return sty;
        }
    }
    const reBorder = (sty) => {
        switch (noBorder) {
            case "true_cn":
                return "noBorder" + sty;
            case "true_en":
                return "noBorderEn" + sty;
            default:
                return sty;
        }
    }
    const fontsizeFun = () => {
        switch (sz) {
            case 'lg':
            case 'sm':
            case 'md':
                return sz;
            default:
                return "primary"
        }
    }
    return (
        <Grid className={
            cx({
                [classes[reBorder('wrap')]]: true,
                [classes[resizeBys("wrapHeight")]]: true,
            })
        } onClick={(e) => e.stopPropagation()}>
            <Grid onClick={handleClick} className={
                cx({
                    [classes[resizeBys('inputHeight')]]: true,
                    [classes[reBorder('inputWrap')]]: true,
                    [classes.inputWrapOpen]: open && !noBorder
                })
            }
                style={{ ...rootStyle }}
            >
                {startIcon && startIcon}
                <Typography className={classes.text} style={{ ...textStyle }}>{values || '请选择'}</Typography>
                {
                    customSvg ? (
                        (
                            <div style={{ ...customSvg }}>
                                <ArrowDropDownIcon classes={{
                                    root: cx({
                                        [classes.ArrowDropDownIconRoot]: true,
                                        [classes.ArrowDropDownIconRootOpen]: open
                                    })
                                }} />
                            </div>
                        )

                    ) : (<ArrowDropDownIcon classes={{
                        root: cx({
                            [classes.ArrowDropDownIconRoot]: true,
                            [classes.ArrowDropDownIconRootOpen]: open
                        })
                    }} />)
                }

            </Grid>
            {
                open && (
                    <Grid onClick={(e) => e.stopPropagation()} className={
                        cx({
                            [classes.contentWrap]: true,
                            [classes.contentWrapOpen]: open
                        })
                    } style={{ ...DropdownboxStyle, DropdownboxitemStyle }} id="select-wrap-content">
                        <Grid className={classes.gridScroll}>
                            <List component="nav" className={classes.root} aria-label="contacts">
                                {
                                    option && option.map((item, key) => {
                                        return (
                                            <ListItem
                                                selected={values === item.label}
                                                classes={{ root: classes.rootListItem, selected: classes.selected }} key={key} button
                                                style={{ ...DropdownboxitemStyle }}
                                                onClick={(event) => selectClick(event, item)}
                                            >
                                                {item.icon ? <Selectzone Icon={item.icon} selected={values === item.label} key={key} classes={{ root: classes.rootListItem, popper: classes.popper, primary: classes[fontsizeFun()] }} selectClick={selectClick} item={item} /> : <ListItemText primary={item.label}
                                                    classes={{ primary: classes[fontsizeFun()] }}
                                                />}
                                            </ListItem>
                                        )
                                    })
                                }
                            </List>
                        </Grid>
                    </Grid>
                )
            }
        </Grid >

    )
}