import { ITemplateConfig } from "../interface";
import styles from "./index.module.css";
import MyInput from "@/components/mui/MyInput";
import classnames from "classnames";
import { useState } from "react";
import FileSelect from "@/components/FileSelect";
import moment from "moment";
// import MySelect, { optionsTransform } from "@/components/mui/MySelect";
import fileSelectIcon from "@/assets/project/fileSelect.svg";

type ConfigFormProps = {
  templateConfigInfo: ITemplateConfig;
};

const ConfigForm = (props: ConfigFormProps) => {
  const { templateConfigInfo } = props;
  const [name, setName] = useState<string>(
    `${templateConfigInfo.title}_${moment(new Date()).format(
      "YYYY_MM_DD_HH_mm"
    )}`
  ); // 任务名称
  const [outputPath, setOutputPath] = useState<string>("ProjectData"); // 输出路径
  const [fileSelectOpen, setFileSelectOpen] = useState(false); // 选择输出路径的弹窗显示控制

  const onFileSelectConfirm = (path: string) => {
    setFileSelectOpen(false);
    setOutputPath(`ProjectData${path === "/" ? "" : path}`);
  };

  const handleFileSelectOnClose = () => {
    setFileSelectOpen(false);
  };

  const handleOpenFileSelect = () => {
    setFileSelectOpen(true);
  };

  const handleNameChange = (e: any) => {
    setName(e.target.value);
  };

  // const options = [
  //   {
  //     key: '1aaaaa',
  //     value: 'a'
  //   },
  //   {
  //     key: 'bbbbbb',
  //     value: 'b'
  //   },
  //   {
  //     key: 'cccccc',
  //     value: 'c'
  //   },
  //   {
  //     key: 'dddddd',
  //     value: 'd'
  //   },
  // ]

  // const [selectValue, setSelectValue] = useState('b')

  return (
    <div className={styles.formBox}>
      <div className={styles.templateDescBox}>
        <div className={styles.templateDescTitle}>模板描述</div>
        <div className={styles.templateDesc}>
          {templateConfigInfo.description}
        </div>
      </div>
      <div
        className={classnames({
          [styles.backgroundTitle]: true,
          [styles.backgroundTitlePass]: true,
        })}
      >
        <img src="" alt="" />
        <span className={styles.backgroundTitleText}>基础信息</span>
      </div>
      <div className={styles.formItems}>
        <div className={styles.formItem}>
          <div
            className={classnames({
              [styles.formItemLable]: true,
              [styles.required]: true,
            })}
          >
            任务名称
          </div>
          <div className={styles.formItem}>
            <MyInput
              value={name}
              onChange={handleNameChange}
              placeholder="请输入任务名称"
            ></MyInput>
          </div>
        </div>
        <div className={styles.formItem}>
          <div
            className={classnames({
              [styles.formItemLable]: true,
              [styles.required]: true,
            })}
          >
            输出路径
          </div>
          <div className={styles.formItem}>
            <MyInput
              value={outputPath}
              InputProps={{
                endAdornment: (
                  <img
                    onClick={handleOpenFileSelect}
                    src={fileSelectIcon}
                    alt="选择输出路径"
                    className={styles.fileSelectImg}
                  />
                ),
              }}
            ></MyInput>
          </div>
        </div>
      </div>
      {/* <MySelect value={selectValue}></MySelect> */}
      <FileSelect
        onClose={handleFileSelectOnClose}
        open={fileSelectOpen}
        onConfirm={onFileSelectConfirm}
      />
    </div>
  );
};

export default ConfigForm;
