import { useState } from "react";
import styles from "./index.module.css";
import { templateConfigJson } from "./mock";
import ConfigForm from "./ConfigForm";
import WorkFlow from "./WorkFlow";
import ButtonComponent from "@/components/mui/Button";
import ArrowBackIosNewIcon from "@mui/icons-material/ArrowBackIosNew";
import IconButton from "@mui/material/IconButton";
import { ITemplateConfig } from "./interface";

const ProjectSubmitWork = () => {
  const [templateConfigInfo, setTemplateConfigInfo] = useState<ITemplateConfig>(
    templateConfigJson as ITemplateConfig
  );

  return (
    <div className={styles.swBox}>
      <div className={styles.swHeader}>
        <div className={styles.swHeaderLeft}>
          <IconButton
            color="primary"
            aria-label="upload picture"
            component="span"
            size="small"
          >
            <ArrowBackIosNewIcon
              sx={{
                color: "rgba(194, 198, 204, 1)",
                width: "12px",
                height: "12px",
              }}
            />
          </IconButton>

          <div className={styles.swTemplateTitle}>
            {templateConfigInfo.title}
          </div>
          <div className={styles.swTemplateVersionBox}>
            <span className={styles.swHeaderLable}>版本：</span>
            <span className={styles.swHeaderValue}>
              {templateConfigInfo.version}
            </span>
          </div>
          <div className={styles.swTemplateUpdateTimeBox}>
            <span className={styles.swHeaderLable}>更新时间：</span>
            <span className={styles.swHeaderValue}>
              {templateConfigInfo.updateTime}
            </span>
          </div>
          <div className={styles.swHeaderGoback}></div>
        </div>
        <div className={styles.swHeaderRight}>
          <ButtonComponent text="提交任务"></ButtonComponent>
        </div>
      </div>
      <div className={styles.swContent}>
        <div className={styles.swFormBox}>
          <ConfigForm templateConfigInfo={templateConfigInfo} />
        </div>
        <div className={styles.swFlowBox}>
          <WorkFlow />
        </div>
      </div>
    </div>
  );
};

export default ProjectSubmitWork;
