export interface ITemplateConfig {
  title: string;
  version: string;
  updateTime: string;
  description: string;
  language: string;
  languageVersion: string;
  tags: Array<string>;
  source: string;
  productId: string;
  tasks?: Array<ITaskFlow | ITaskBatch>;
}

export interface ITaskFlow {
  id: string;
  title: string;
  description: string;
  position: {
    x: number;
    y: number;
  };
  type: "flow";
  parentNode: string;
  parameters: Array<IParameter>;
  edges: Array<IEdge>;
}

export interface ITaskBatch {
  id: string;
  title: string;
  description: string;
  position: {
    x: number;
    y: number;
  };
  type: "batch";
  parameters: Array<IParameter>;
  edges: Array<IEdge>;
}

export interface IParameter {
  hidden: boolean;
  id?: string;
  name: string;
  required: boolean;
  domType: IDomType;
  dataType: string;
  value: string;
  description: string;
  validators: Array<IValidator>;
  choices: Array<IChoice>;
}

export type IDomType =
  | "pathSelect"
  | "datasetSelect"
  | "fileSelect"
  | "input"
  | "File"
  | "select"
  | "multipleSelect"
  | "radio"
  | "checkbox";

// 待定
export type IValidator = {
  regex: string;
  message: string;
};

export interface IChoice {
  key: string;
  value: boolean | string | number;
}

export interface IEdge {
  id: string;
  source: string;
  sourceHandle: string;
  target: string;
  targetHandle: string;
  lable: string;
}
