import { makeAutoObservable } from "mobx";
type projectInfo = {
  id?: string;
  name?: string;
  desc?: string;
  projectRole?: string;
  filetoken?: string;
};

type productInfo = {
  id?: string;
  name?: string;
};

const sessionStorageCurrentProjectInfo = JSON.parse(
  sessionStorage.getItem("currentProjectInfo") || "{}"
);
const sessionStorageCurrentProductInfo = JSON.parse(
  sessionStorage.getItem("currentProductInfo") || "{}"
);
const sessionStorageProjectList = JSON.parse(
  sessionStorage.getItem("projectList") || "[]"
);

class currentProject {
  constructor() {
    makeAutoObservable(this);
  }

  // 选中的项目
  currentProjectInfo: projectInfo = sessionStorageCurrentProjectInfo;
  // 选中的产品下的项目列表
  projectList: Array<projectInfo> = sessionStorageProjectList;
  // 选中的产品
  currentProductInfo: productInfo = sessionStorageCurrentProductInfo;
  setProjectList = (list: Array<projectInfo>) => {
    this.projectList = list;
    sessionStorage.setItem("projectList", JSON.stringify(list));
  };
  changeProject = (project: projectInfo) => {
    this.currentProjectInfo = project;
    sessionStorage.setItem("currentProjectInfo", JSON.stringify(project));
  };
  changeProductInfo = (productInfo: productInfo) => {
    this.currentProductInfo = productInfo;
    sessionStorage.setItem("currentProductInfo", JSON.stringify(productInfo));
  };
}

const currentProjectStore = new currentProject();

export default currentProjectStore;
