import { saveUserSpec } from "@/api/workbench_api";
import MyDialog from "@/components/mui/MyDialog";
import MyInput from "@/components/mui/MyInput";
import { checkIsNumberLetterChinese } from "@/utils/util";
import _ from "lodash";
import { useState } from "react";
import useMyRequest from "@/hooks/useMyRequest";
import { saveBatchActor } from "@/api/project_api";
import { useStores } from "@/store";

// import styles from "./index.module.css";
import { useMessage } from "@/components/MySnackbar";
import { toJS } from "mobx";
import { ITask } from "@/views/Project/ProjectSubmitWork/interface";
interface IProps {
	saveFormDialog: boolean;
	setSaveFormDialog: (val: boolean) => void;
	operatorList: ITask[];
}
const SaveOperator = (props: IProps) => {
	const { saveFormDialog, setSaveFormDialog, operatorList } = props;
	const { currentProjectStore } = useStores();
	const Message = useMessage();
	const productId = toJS(currentProjectStore.currentProductInfo.id);
	const [title, setTitle] = useState("");
	const [version, setVersion] = useState("1.0.0");
	const [description, setDescription] = useState("");

	// 保存批算子
	const { run: saveBatchActorRun } = useMyRequest(saveBatchActor, {
		onSuccess: (res) => {
			Message.success("保存算子成功");
			setSaveFormDialog(false);
			sessionStorage.setItem("operatorList", "[]");
			console.log("res", res);
		},
	});

	const [titleHelper, setTitleHelper] = useState({
		// 算子名称错误提示
		error: false,
		helperText: "",
	});
	const [versionHelper, setVersionHelper] = useState({
		// 算子版本错误提示
		error: false,
		helperText: "",
	});

	// 关闭表单弹窗
	const handleCloseDialog = () => {
		setSaveFormDialog(false);
	};

	// 算子名称
	const handleTitleChange = (e: any) => {
		const title = e.target.value;
		setTitle(title);
		checkTitle(title);
	};

	// 算子版本
	const handleVersionChange = (e: any) => {
		let version = e.target.value;
		setVersion(version);
		checkVersion(version);
	};

	// 算子描述
	const handleDescriptionChange = (e: any) => {
		let description = e.target.value;
		if (description.length < 301) {
			setDescription(description);
		}
	};

	// 校验算子名称
	const checkTitle = (title: string) => {
		if (!title) {
			setTitleHelper({
				error: true,
				helperText: "必须输入算子名称",
			});
			return false;
		} else if (title.length > 15) {
			setTitleHelper({
				error: true,
				helperText: "格式不正确，必须在15字符以内，仅限大小写字母、数字、中文",
			});
			return false;
		} else if (!checkIsNumberLetterChinese(title)) {
			setTitleHelper({
				error: true,
				helperText: "格式不正确，必须在15字符以内，仅限大小写字母、数字、中文",
			});
			return false;
		} else {
			setTitleHelper({
				error: false,
				helperText: "",
			});
			return true;
		}
	};

	// 校验版本号格式
	const checkVersion = (version: string) => {
		if (/^[1-9]\d?(\.(0|[1-9]\d?)){2}$/.test(version)) {
			setVersionHelper({
				error: false,
				helperText: "",
			});
			return true;
		} else {
			setVersionHelper({
				error: true,
				helperText: "格式不正确，必须为X.Y.Z格式，且XYZ必须为0~99的正整数",
			});
			return false;
		}
	};

	// 坐标转换
	const positionTransform = () => {
		const copyOperatorList: ITask[] = _.cloneDeep(operatorList);
		const positionXArr = copyOperatorList.map((operatorLi) => {
			return operatorLi.position.x;
		});
		const positionYArr = copyOperatorList.map((operatorLi) => {
			return operatorLi.position.y;
		});
		let minPositionX = Math.min(...positionXArr);
		let minPositionY = Math.min(...positionYArr);
		let startingPointX = minPositionX - 40;
		let startingPointY = minPositionY - 10;
		return copyOperatorList.map((operatorLi) => {
			return {
				...operatorLi,
				position: {
					x: operatorLi.position.x - startingPointX,
					y: operatorLi.position.y - startingPointY,
				},
			};
		});
	};

	// 表单弹窗确定，新建算子
	const handleOncofirm = () => {
		console.log(operatorList);
		if (checkTitle(title) && checkVersion(version)) {
			saveBatchActorRun({
				query: {
					productId: productId as string,
					batchName: title,
					batchVersion: version,
					description: description,
				},
				body: positionTransform(),
				// body: [
				// 	{
				// 		id: "62c7965c9bf7ba39f2dcefc0",
				// 		title: "RecordFileReader",
				// 		description: "这是一段RecordFileReader算子的描述",
				// 		type: "FLOW",
				// 		productId: "cadd",
				// 		creator: "root",
				// 		parameters: [
				// 			{
				// 				name: "raw",
				// 				classType: "BOOLEAN",
				// 				classTypeName: "Boolean",
				// 				required: false,
				// 				defaultValue: "false",
				// 				description: "",
				// 				hidden: false,
				// 				many: false,
				// 				isnull: false,
				// 				promoted: false,
				// 				order: 0,
				// 				domType: "RADIO",
				// 				validators: [],
				// 				choices: [
				// 					{
				// 						value: "true",
				// 					},
				// 					{
				// 						value: "false",
				// 					},
				// 				],
				// 				parameterGroup: "basis",
				// 				linked: false,
				// 			},
				// 			{
				// 				name: "sep",
				// 				classType: "STRING",
				// 				classTypeName: "String",
				// 				required: false,
				// 				description: "",
				// 				hidden: false,
				// 				many: false,
				// 				isnull: false,
				// 				promoted: false,
				// 				order: 0,
				// 				domType: "INPUT",
				// 				validators: [],
				// 				choices: [],
				// 				parameterGroup: "basis",
				// 				linked: false,
				// 			},
				// 			{
				// 				name: "contains_sep",
				// 				classType: "BOOLEAN",
				// 				classTypeName: "Boolean",
				// 				required: false,
				// 				defaultValue: "false",
				// 				description: "",
				// 				hidden: false,
				// 				many: false,
				// 				isnull: false,
				// 				promoted: false,
				// 				order: 0,
				// 				domType: "RADIO",
				// 				validators: [],
				// 				choices: [
				// 					{
				// 						value: "true",
				// 					},
				// 					{
				// 						value: "false",
				// 					},
				// 				],
				// 				parameterGroup: "basis",
				// 				linked: false,
				// 			},
				// 			{
				// 				name: "encoding",
				// 				classType: "STRING",
				// 				classTypeName: "String",
				// 				required: false,
				// 				defaultValue: "UTF-8",
				// 				description: "",
				// 				hidden: false,
				// 				many: false,
				// 				isnull: false,
				// 				promoted: false,
				// 				order: 0,
				// 				domType: "INPUT",
				// 				validators: [],
				// 				choices: [],
				// 				parameterGroup: "senior",
				// 				linked: false,
				// 			},
				// 			{
				// 				name: "chunk_size",
				// 				classType: "INT",
				// 				classTypeName: "Int",
				// 				required: false,
				// 				defaultValue: "1000",
				// 				description: "",
				// 				hidden: false,
				// 				many: false,
				// 				isnull: false,
				// 				promoted: false,
				// 				order: 0,
				// 				domType: "INPUT",
				// 				validators: [
				// 					{
				// 						regex: "^[1-9]\\d*$",
				// 					},
				// 				],
				// 				choices: [],
				// 				parameterGroup: "senior",
				// 				linked: false,
				// 			},
				// 			{
				// 				name: "compression",
				// 				classType: "STRING",
				// 				classTypeName: "String",
				// 				required: false,
				// 				description: "",
				// 				hidden: false,
				// 				many: false,
				// 				isnull: false,
				// 				promoted: false,
				// 				order: 0,
				// 				domType: "INPUT",
				// 				validators: [],
				// 				choices: [],
				// 				parameterGroup: "senior",
				// 				linked: false,
				// 			},
				// 			{
				// 				name: "cpus",
				// 				classType: "INT",
				// 				classTypeName: "Int",
				// 				required: false,
				// 				defaultValue: "1",
				// 				description: "",
				// 				hidden: true,
				// 				many: false,
				// 				isnull: false,
				// 				promoted: false,
				// 				order: 0,
				// 				domType: "INPUT",
				// 				validators: [
				// 					{
				// 						regex: "^[1-9]\\d*$",
				// 					},
				// 				],
				// 				choices: [],
				// 				parameterGroup: "hardware",
				// 				linked: false,
				// 			},
				// 			{
				// 				name: "ntasks",
				// 				classType: "INT",
				// 				classTypeName: "Int",
				// 				required: false,
				// 				defaultValue: "1",
				// 				description: "",
				// 				hidden: true,
				// 				many: false,
				// 				isnull: false,
				// 				promoted: false,
				// 				order: 0,
				// 				domType: "INPUT",
				// 				validators: [
				// 					{
				// 						regex: "^[1-9]\\d*$",
				// 					},
				// 				],
				// 				choices: [],
				// 				parameterGroup: "hardware",
				// 				linked: false,
				// 			},
				// 			{
				// 				name: "partition",
				// 				classType: "STRING",
				// 				classTypeName: "String",
				// 				required: false,
				// 				defaultValue: "c-4-1",
				// 				description: "",
				// 				hidden: true,
				// 				many: false,
				// 				isnull: false,
				// 				promoted: false,
				// 				order: 0,
				// 				domType: "INPUT",
				// 				choices: [],
				// 				parameterGroup: "hardware",
				// 				linked: false,
				// 			},
				// 			{
				// 				name: "parallelism",
				// 				classType: "INT",
				// 				classTypeName: "Int",
				// 				required: false,
				// 				defaultValue: "1",
				// 				description: "",
				// 				hidden: true,
				// 				many: false,
				// 				isnull: false,
				// 				promoted: false,
				// 				order: 0,
				// 				domType: "INPUT",
				// 				validators: [
				// 					{
				// 						regex: "^[1-9]\\d*$",
				// 					},
				// 				],
				// 				choices: [],
				// 				parameterGroup: "hardware",
				// 				linked: false,
				// 			},
				// 		],
				// 		edges: [
				// 			{
				// 				id: "d3ffaf04-b3dc-4c1c-a3c0-a897536131ba",
				// 				source: "62c7965c9bf7ba39f2dcefc0",
				// 				target: "62c7965c9bf7ba39f2dcefc1",
				// 			},
				// 		],
				// 		version: "1.0.0",
				// 		allVersions: ["1.0.0", "2.0.0"],
				// 		scatter: false,
				// 		_class: "com.cloudam.c3.domain.ActorSpec",
				// 	},
				// 	{
				// 		id: "62c7965c9bf7ba39f2dcefc2",
				// 		title: "Docking",
				// 		description: "这是一段Docking算子的描述",
				// 		type: "FLOW",
				// 		productId: "cadd",
				// 		creator: "root",
				// 		parameters: [
				// 			{
				// 				name: "core_num",
				// 				classType: "INT",
				// 				classTypeName: "Int",
				// 				required: false,
				// 				defaultValue: "1",
				// 				description: "",
				// 				hidden: false,
				// 				many: false,
				// 				isnull: false,
				// 				promoted: false,
				// 				order: 0,
				// 				domType: "INPUT",
				// 				validators: [
				// 					{
				// 						regex: "^[1-9]\\d*$",
				// 					},
				// 				],
				// 				choices: [],
				// 				parameterGroup: "basis",
				// 				linked: false,
				// 			},
				// 			{
				// 				name: "centerX",
				// 				classType: "INT",
				// 				classTypeName: "Int",
				// 				required: true,
				// 				description: "",
				// 				hidden: false,
				// 				many: false,
				// 				isnull: false,
				// 				promoted: false,
				// 				order: 0,
				// 				domType: "INPUT",
				// 				validators: [
				// 					{
				// 						regex: "^[1-9]\\d*$",
				// 					},
				// 				],
				// 				choices: [],
				// 				parameterGroup: "basis",
				// 				linked: false,
				// 			},
				// 			{
				// 				name: "centerY",
				// 				classType: "INT",
				// 				classTypeName: "Int",
				// 				required: true,
				// 				description: "",
				// 				hidden: false,
				// 				many: false,
				// 				isnull: false,
				// 				promoted: false,
				// 				order: 0,
				// 				domType: "INPUT",
				// 				validators: [
				// 					{
				// 						regex: "^[1-9]\\d*$",
				// 					},
				// 				],
				// 				choices: [],
				// 				parameterGroup: "basis",
				// 				linked: false,
				// 			},
				// 			{
				// 				name: "centerZ",
				// 				classType: "INT",
				// 				classTypeName: "Int",
				// 				required: true,
				// 				description: "",
				// 				hidden: false,
				// 				many: false,
				// 				isnull: false,
				// 				promoted: false,
				// 				order: 0,
				// 				domType: "INPUT",
				// 				validators: [
				// 					{
				// 						regex: "^[1-9]\\d*$",
				// 					},
				// 				],
				// 				choices: [],
				// 				parameterGroup: "basis",
				// 				linked: false,
				// 			},
				// 			{
				// 				name: "boxSizeX",
				// 				classType: "INT",
				// 				classTypeName: "Int",
				// 				required: true,
				// 				description: "",
				// 				hidden: false,
				// 				many: false,
				// 				isnull: false,
				// 				promoted: false,
				// 				order: 0,
				// 				domType: "INPUT",
				// 				validators: [
				// 					{
				// 						regex: "^[1-9]\\d*$",
				// 					},
				// 				],
				// 				choices: [],
				// 				parameterGroup: "basis",
				// 				linked: false,
				// 			},
				// 			{
				// 				name: "boxSizeY",
				// 				classType: "INT",
				// 				classTypeName: "Int",
				// 				required: true,
				// 				description: "",
				// 				hidden: false,
				// 				many: false,
				// 				isnull: false,
				// 				promoted: false,
				// 				order: 0,
				// 				domType: "INPUT",
				// 				validators: [
				// 					{
				// 						regex: "^[1-9]\\d*$",
				// 					},
				// 				],
				// 				choices: [],
				// 				parameterGroup: "basis",
				// 				linked: false,
				// 			},
				// 			{
				// 				name: "boxSizeZ",
				// 				classType: "INT",
				// 				classTypeName: "Int",
				// 				required: true,
				// 				description: "",
				// 				hidden: false,
				// 				many: false,
				// 				isnull: false,
				// 				promoted: false,
				// 				order: 0,
				// 				domType: "INPUT",
				// 				validators: [
				// 					{
				// 						regex: "^[1-9]\\d*$",
				// 					},
				// 				],
				// 				choices: [],
				// 				parameterGroup: "basis",
				// 				linked: false,
				// 			},
				// 			{
				// 				name: "poses_num",
				// 				classType: "INT",
				// 				classTypeName: "Int",
				// 				required: false,
				// 				defaultValue: "9",
				// 				description: "",
				// 				hidden: false,
				// 				many: false,
				// 				isnull: false,
				// 				promoted: false,
				// 				order: 0,
				// 				domType: "INPUT",
				// 				validators: [
				// 					{
				// 						regex: "^[1-9]\\d*$",
				// 					},
				// 				],
				// 				choices: [],
				// 				parameterGroup: "senior",
				// 				linked: false,
				// 			},
				// 			{
				// 				name: "verbosity",
				// 				classType: "INT",
				// 				classTypeName: "Int",
				// 				required: false,
				// 				defaultValue: "1",
				// 				description: "",
				// 				hidden: false,
				// 				many: false,
				// 				isnull: false,
				// 				promoted: false,
				// 				order: 0,
				// 				domType: "INPUT",
				// 				validators: [
				// 					{
				// 						regex: "^[1-9]\\d*$",
				// 					},
				// 				],
				// 				choices: [],
				// 				parameterGroup: "senior",
				// 				linked: false,
				// 			},
				// 			{
				// 				name: "exhaustiveness",
				// 				classType: "INT",
				// 				classTypeName: "Int",
				// 				required: false,
				// 				defaultValue: "1",
				// 				description: "",
				// 				hidden: false,
				// 				many: false,
				// 				isnull: false,
				// 				promoted: false,
				// 				order: 0,
				// 				domType: "INPUT",
				// 				validators: [
				// 					{
				// 						regex: "^[1-9]\\d*$",
				// 					},
				// 				],
				// 				choices: [],
				// 				parameterGroup: "senior",
				// 				linked: false,
				// 			},
				// 			{
				// 				name: "cpus",
				// 				classType: "INT",
				// 				classTypeName: "Int",
				// 				required: false,
				// 				defaultValue: "1",
				// 				description: "",
				// 				hidden: true,
				// 				many: false,
				// 				isnull: false,
				// 				promoted: false,
				// 				order: 0,
				// 				domType: "INPUT",
				// 				validators: [
				// 					{
				// 						regex: "^[1-9]\\d*$",
				// 					},
				// 				],
				// 				choices: [],
				// 				parameterGroup: "hardware",
				// 				linked: false,
				// 			},
				// 			{
				// 				name: "ntasks",
				// 				classType: "INT",
				// 				classTypeName: "Int",
				// 				required: false,
				// 				defaultValue: "4",
				// 				description: "",
				// 				hidden: true,
				// 				many: false,
				// 				isnull: false,
				// 				promoted: false,
				// 				order: 0,
				// 				domType: "INPUT",
				// 				validators: [
				// 					{
				// 						regex: "^[1-9]\\d*$",
				// 					},
				// 				],
				// 				choices: [],
				// 				parameterGroup: "hardware",
				// 				linked: false,
				// 			},
				// 			{
				// 				name: "partition",
				// 				classType: "STRING",
				// 				classTypeName: "String",
				// 				required: false,
				// 				defaultValue: "c-4-1",
				// 				description: "",
				// 				hidden: true,
				// 				many: false,
				// 				isnull: false,
				// 				promoted: false,
				// 				order: 0,
				// 				domType: "INPUT",
				// 				validators: [],
				// 				choices: [],
				// 				parameterGroup: "hardware",
				// 				linked: false,
				// 			},
				// 			{
				// 				name: "parallelism",
				// 				classType: "INT",
				// 				classTypeName: "Int",
				// 				required: false,
				// 				defaultValue: "6",
				// 				description: "",
				// 				hidden: true,
				// 				many: false,
				// 				isnull: false,
				// 				promoted: false,
				// 				order: 0,
				// 				domType: "INPUT",
				// 				validators: [
				// 					{
				// 						regex: "^[1-9]\\d*$",
				// 					},
				// 				],
				// 				choices: [],
				// 				parameterGroup: "hardware",
				// 				linked: false,
				// 			},
				// 		],
				// 		edges: [
				// 			{
				// 				id: "33f82dd3-47ed-4aae-85bc-0a9e763e0981",
				// 				source: "62c7965c9bf7ba39f2dcefc2",
				// 				target: "62c7965c9bf7ba39f2dcefc3",
				// 			},
				// 		],
				// 		version: "1.0.0",
				// 		allVersions: ["1.0.0", "2.0.0"],
				// 		scatter: false,
				// 		_class: "com.cloudam.c3.domain.ActorSpec",
				// 	},
				// ],
			});
			// operatorList
			// if (id) {
			// 	saveUserSpecRun({
			// 		title,
			// 		version,
			// 		description,
			// 		tasks: templateConfigInfo,
			// 		productId,
			// 		id,
			// 		creator,
			// 	});
			// } else {
			// 	saveUserSpecRun({
			// 		title,
			// 		version,
			// 		description,
			// 		tasks: templateConfigInfo,
			// 		productId,
			// 	});
			// }
		}
	};

	return (
		<MyDialog
			open={saveFormDialog}
			title="保存算子"
			onClose={handleCloseDialog}
			onConfirm={handleOncofirm}
		>
			<div style={{ width: "388px" }}>
				<MyInput
					value={title}
					label="算子名称"
					onChange={handleTitleChange}
					required
					error={titleHelper.error}
					helperText={titleHelper.helperText}
					style={{ margin: "20px 0" }}
				></MyInput>
				<MyInput
					value={version}
					label="版本号"
					onChange={handleVersionChange}
					error={versionHelper.error}
					helperText={versionHelper.helperText}
					style={{ marginBottom: "20px" }}
				></MyInput>
				<div style={{ position: "relative" }}>
					<MyInput
						value={description}
						id="desc"
						label="模板描述"
						placeholder="模板描述"
						onChange={handleDescriptionChange}
						multiline
						rows={4}
					/>
					<span
						style={{
							position: "absolute",
							bottom: "7px",
							right: "12px",
							color: description.length >= 300 ? "#d32f2f" : "#C2C6CC",
						}}
					>
						{description.length}/300
					</span>
				</div>
			</div>
		</MyDialog>
	);
};

export default SaveOperator;
