// 从下往上弹的全屏抽屉
import { useState } from "react";
import style from "./index.module.css";
import classNames from "classnames";
import CloseOutlinedIcon from "@mui/icons-material/CloseOutlined";

type IFullScreenDrawerProps = {
	children: React.ReactNode;
	handleClose: any;
};

const FullScreenDrawer = (props: IFullScreenDrawerProps) => {
	const { children, handleClose } = props;
	const [closeing, setCloseing] = useState(false);

	const handleReadyToClose = () => {
		setCloseing(true);
		setTimeout(() => {
			setCloseing(false);
			handleClose();
		}, 300);
	};
	return (
		<div
			className={classNames({
				[style.drawerBox]: true,
				[style.drawerBoxHidden]: closeing,
			})}
		>
			<div
				className={classNames({
					[style.closeBox]: true,
					[style.closeBoxHidden]: closeing,
				})}
			>
				<CloseOutlinedIcon
					className={style.closeiIcon}
					onClick={() => handleReadyToClose()}
				/>
			</div>
			<div
				className={classNames({
					[style.contentBox]: true,
					[style.contentBoxHidden]: closeing,
				})}
			>
				{children}
			</div>
		</div>
	);
};

export default FullScreenDrawer;
