// 确认提示框，   支持同一页面多个提示框
import * as React from "react";
import { ReactNode, useMemo } from "react";
import Box from "@mui/material/Box";
import MyButton from "./MyButton";
import tipsIcon from "@/assets/project/information-outline.svg";
import Popper from "@mui/material/Popper";

interface IMyPopconfirmProps {
	title: string | ReactNode;
	placement?:
		| "auto-end"
		| "auto-start"
		| "auto"
		| "bottom-end"
		| "bottom-start"
		| "bottom"
		| "left-end"
		| "left-start"
		| "left"
		| "right-end"
		| "right-start"
		| "right"
		| "top-end"
		| "top-start"
		| "top";
	anchorEl?: null | HTMLElement;
	cancelText?: string;
	okText?: string;
	showCancel?: boolean;
	onCancel?: any;
	onConfirm?: any;
}

const MyPopconfirm = (props: IMyPopconfirmProps) => {
	const {
		title,
		anchorEl,
		placement = "bottom",
		cancelText = "取消",
		okText = "确认",
		showCancel = true,
		onCancel,
		onConfirm,
	} = props;

	const open = useMemo(() => {
		return Boolean(anchorEl);
	}, [anchorEl]);

	const id = open ? "simple-popper" : undefined;

	const handleCancel = () => {
		onCancel && onCancel();
	};

	const handleOk = () => {
		onConfirm && onConfirm();
	};

	return (
		<Popper
			id={id}
			open={open}
			anchorEl={anchorEl}
			placement={placement}
			sx={{
				zIndex: 2000,
				bgcolor: "#fff",
				minWidth: "200px",
				borderRadius: "2px",
				padding: "20px 16px",
				boxShadow: "0px 3px 10px 0px rgba(0, 24, 57, 0.14)",
			}}
		>
			<Box sx={{ marginBottom: "16px" }}>
				<img
					style={{
						width: "16px",
						marginRight: "12px",
						position: "relative",
						top: "3px",
					}}
					src={tipsIcon}
					alt=""
				/>
				{title}
			</Box>
			<Box sx={{ display: "flex", justifyContent: "flex-end" }}>
				{showCancel && (
					<MyButton
						text={cancelText}
						variant="outlined"
						color="inherit"
						onClick={handleCancel}
						style={{ marginRight: "12px" }}
					/>
				)}
				<MyButton text={okText}  onClick={handleOk} />
			</Box>
		</Popper>
	);
};

export default MyPopconfirm;
