import CodeMirror from "@uiw/react-codemirror";

type ICodeType = {
	value: string;
	onChange: any;
	height?: string;
	theme?: "light" | "dark";
};

const Code = (props: ICodeType) => {
	const { value, onChange, height, theme = "dark" } = props;
	return (
		<CodeMirror
			height={height || "100%"}
			value={value}
			onChange={(e) => onChange(e)}
			theme={theme}
		/>
	);
};
export default Code;
