import { deleteActorenv } from "@/api/resourceCenter";
import useMyRequest from "@/hooks/useMyRequest";
import { useMessage } from "@/components/MySnackbar";
import MyDialog from "@/components/mui/MyDialog";

interface IDeleteEnvironmentProps {
	id: string;
	open: boolean;
	setDeleteOpen: any;
}

const DeleteEnvironment = (props: IDeleteEnvironmentProps) => {
	const { open, id, setDeleteOpen } = props;
	const Message = useMessage();
	const { run, loading } = useMyRequest(deleteActorenv, {
		onSuccess: () => {
			setDeleteOpen(false);
			Message.success("删除成功");
		},
	});
	const handleConfirm = () => {
		console.log(id);
		run({ id });
	};
	return (
		<MyDialog
			okColor="error"
			open={open}
			onClose={() => setDeleteOpen(false)}
			title="删除环境"
			okText="删除"
			onConfirm={() => handleConfirm()}
			loading={loading}
		>
			<span>删除后无法恢复，确认删除吗？</span>
		</MyDialog>
	);
};

export default DeleteEnvironment;
