/*
 * @Author: 吴永生 15770852798@163.com
 * @Date: 2022-10-17 14:35:11
 * @LastEditors: 吴永生 15770852798@163.com
 * @LastEditTime: 2022-10-19 21:11:50
 * @FilePath: /bkunyun/src/views/ResourceCenter/UserResources/WorkflowOperator/index.tsx
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
// 应用环境
import { useEffect, useState } from "react";
import { observer } from "mobx-react";

import SearchInput from "@/components/BusinessComponents/SearchInput";
import MySelect from "@/components/mui/MySelect";
import MyButton from "@/components/mui/MyButton";
import OperatorCard from "./components/OperatorCard";
import AddOperator from "./components/AddOperator";
import { useStores } from "@/store";
import { getOperatorList, IOperatorListParams } from "@/api/resourceCenter";

import styles from "./index.module.css";
import useMyRequest from "@/hooks/useMyRequest";
import { IOperatorInfo } from "./interface";

const WorkflowOperator = observer(() => {
	const [addOpen, setAddOpen] = useState<boolean>(false);
	/** 产品store */
	const { productListStore } = useStores();
	/**  算子列表参数 */
	const [searchParams, setSearchParams] = useState<IOperatorListParams>({
		keyword: "",
		productId: "",
		type: "",
	});

	const [list, setList] = useState<IOperatorInfo[]>();

	const { run: getList } = useMyRequest(getOperatorList, {
		onSuccess: (res) => {
			console.log(res);
			setList(res?.data);
		},
	});

	useEffect(() => {
		getList();
	}, []);

	return (
		<>
			<div className={styles.indexBox}>
				<div className={styles.headerBox}>
					<div>
						<SearchInput
							sx={{ width: 340, marginRight: "16px" }}
							placeholder="输入关键词搜索"
							value={searchParams.keyword}
							onChange={(e) => {
								setSearchParams({ ...searchParams, keyword: e.target.value });
							}}
						/>
						<MySelect
							title="所属产品"
							isTitle={true}
							options={productListStore?.productList || []}
							value={searchParams.keyword}
							onChange={(e) => {
								setSearchParams({ ...searchParams, productId: e });
							}}
							className={styles.searchSelectBox}
							sx={{ width: "150px", height: "32px" }}
						/>
						<MySelect
							title="环境类型"
							isTitle={true}
							value={searchParams.keyword}
							onChange={(e) => {
								setSearchParams({ ...searchParams, type: e });
							}}
							options={[
								{
									label: "批式",
									value: "BATCH",
								},
								{
									label: "流式",
									value: "FLOW",
								},
							]}
							sx={{ width: "150px", height: "32px" }}
						/>
					</div>
					<MyButton
						text="构建算子"
						img={
							<span
								style={{ fontSize: "14px", marginRight: "8px" }}
								className="iconfont icon-dianzan"
							></span>
						}
						onClick={() => setAddOpen(true)}
					></MyButton>
				</div>
				<div className={styles.contentBox}>
					{list?.map((item) => {
						return <OperatorCard operatorInfo={item} />;
					})}
				</div>
			</div>
			{addOpen && <AddOperator setAddOpen={setAddOpen} />}
		</>
	);
});

export default WorkflowOperator;
