/*
 * @Author: 吴永生#A02208 yongsheng.wu@wholion.com
 * @Date: 2022-06-21 20:03:56
 * @LastEditors: 吴永生#A02208 yongsheng.wu@wholion.com
 * @LastEditTime: 2022-07-12 11:51:17
 * @FilePath: /bkunyun/src/views/Project/ProjectSubmitWork/interface.ts
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
type IType = "BATCH" | "FLOW";
export interface IParameter {
  hidden: boolean; // 使用模板时是否展示   true 不展示 用户不需要填写
  id?: string;
  name: string; // 参数名称
  required: boolean; // 是否必填
  defaultValue: any; // 默认值
  domType: IDomType; // 前端组件类型
  classType: string; // 后端数据类型
  classTypeName: string; // 前端展示的数据类型 classType对应的描述
  value: any; // 值
  description: string; // 该参数的描述、解释
  language: string; // 
  languageVersion: string; // 
  tags: Array<string>;
  source: string;
  productId: string;
  // tasks: ITask[];
  linked?: boolean;
  validators: Array<IValidator>; // 校验方式的数组， 有正则和对应的提示语
  choices: Array<IChoice>; // 提供给用户选择的选项组
  error?: boolean; // 表单校验是否通过
  helperText?: string; // 表单校验提示文案
  parameterGroup?: string; // 
}

export type IExecutionStatus = "Pending" | "Running" | "Done" | "Failed";

export interface ITask {
  id: string;
  title: string; // 批流算子名称
  description: string; // 描述
  version?: string; // 版本
  allVersions?: string[]; // 全部版本
  position: { // 流程图位置信息
    x: number;
    y: number;
  };
  tags?: string[];
  type: IType | string; // 算子类型（批算子、流算子）
  parentNode?: string; // 
  parameters: Array<IParameter>; // 参数组
  edges: Array<IEdge>;
  isCheck?: boolean; // 表单校验是否通过
  executionStatus?: IExecutionStatus; // 算子的状态
}

export interface ITemplateConfig { // 模板信息
  title: string; // 标题
  version: string; // 版本
  updateTime?: string; // 更新时间
  description: string; // 模板描述
  language: string;
  languageVersion: string;
  tags: Array<string>;
  source: string;
  productId: string; // 产品id
  tasks: ITask[]; // 算子组
  id: string;
}

export type IDomType = // 前端组件类型
  | "path"
  | "dataset"
  | "file"
  | "input"
  | "select"
  | "multipleselect"
  | "radio"
  | "checkbox";

// 待定
export type IValidator = { // 表单校验中的一项
  regex: string;
  message: string;
};

export interface IChoice { // 表单选项中的一项
  label: string;
  value: string;
}

export interface IEdge {
  id: string;
  source: string;
  sourceHandle: string;
  target: string;
  targetHandle: string;
  label?: string;
}

// 提交任务时的动态表单的数据结构
export type IRenderTasks = Array<IRenderTask>; // 将批算子、流算子、批算子下的流算子混合在一起的一维数组转换成批算子、流算子的二维数组
export type IRenderTask = {
  id: string;
  title: string;
  description: string;
  position: {
    x: number;
    y: number;
  };
  type: IType | string;
  parameters: Array<IParameter>;
  edges: Array<IEdge>;
  flows: ITask[];
  isCheck: boolean; // 里面的子项表单校验是否全部通过
};

// 工作流详情
export interface ITaskInfo extends ITemplateConfig {
  name: string; // 任务（工作流）名称
  outputPath: string; // 任务结果  输出文件路径
  state: IState; // 任务状态
  specTitle: string; // 源模板
  specVersion: string; // 源模板版本
  jobCost: string; // 花费（元）
  creator: string; // 创建人
  createTime: string; // 创建时间
  costTime: string; // 运行时间
  logPath: string; // 日志文件
  outputs?: any; // 结果文件
}

type IState = "SUCCEEDED" | "RUNNING" | "ABORTED" | "FAILED";
