import { List } from "react-virtualized";

interface IVirtuallyListProps {
	list: Array<any>;
	renderRow: any;
}

const VirtuallyList = (props: IVirtuallyListProps) => {
	const { list, renderRow } = props;
	return (
		<List
			width={300}
			height={300}
			rowCount={list.length}
			rowHeight={20}
			rowRenderer={renderRow}
			overscanRowCount={20}
		/>
	);
};
export default VirtuallyList;
