import React from "react";
import { useCallback, useEffect, useState, useRef, useMemo } from "react";
import { Column, Table, AutoSizer } from "react-virtualized";
import style from "./index.module.scss";
import "react-virtualized/styles.css"; // only needs to be imported once
import MyCircularProgress from "@/components/mui/MyCircularProgress";

type Order = "ASC" | "DESC"; // 升序为asc，降序为desc。

export type sortState = {
	field: string | null | undefined | ""; // 根据哪个属性来排序
	order: Order | null | undefined | "";
};

interface IVirtuallyTableProps {
	rows: Array<any>; // 表格数据
	headCells: Array<any>; // 表头配置
	tableKey?: string; // 表格数据的key
	loading?: boolean; // 是否正在加载数据
	hasCheckbox?: boolean; // 是否有复选框
	selectItems?: Array<any>; // 选中的项
	setSelectItems?: any; // 设置选中的项
	// fixedHead?: boolean; // 是否是固定表头
	noDataText?: string; // 无数据提示文案
	// hasTableFooter?: boolean; // 是否有分页组件
	// page?: number; // 当前页
	// pageChange?: any; // 页码改变
	// count?: number; // 总页数
	// totalElements?: number; // 数据总量 不止是列表渲染的长度
	sortState?: sortState; // 排序状态
	setSortState?: any; // 设置排序状态
	// paginationType?: "simple" | "complex"; // 分页组件的类型   simple简洁式  complex复杂、带每页数量切换、总数等
	// rowsPerPage?: number; // 每页多少条数据
	// handleChangeRowsPerPage?: any; // 每页多少条数据变化
	nodataText?: any; // 无数据文案
	handleRow?: any; // 点击一行
	activeId?: string; // 选中的一行的id
	disableFn?: any; // 禁用时根据disableFn来判断是否禁用
}

const VirtuallyTable = (props: IVirtuallyTableProps) => {
	const {
		rows,
		headCells,
		tableKey = "id",
		loading = false,
		hasCheckbox = false,
		selectItems = [],
		setSelectItems,
		sortState,
		setSortState,
		nodataText,
		handleRow,
		activeId,
		disableFn,
	} = props;

	const virtuallyTableBoxRef: any = useRef(null);
	const virtuallyTableRef: any = useRef(null);

	const [width, setWidth] = useState(0);
	const [height, setHeight] = useState(0);

	const getTableWidthHeight = () => {
		setWidth(virtuallyTableBoxRef?.current?.offsetWidth || 1000);
		setHeight(virtuallyTableBoxRef?.current?.offsetHeight || 300);
	};

	useEffect(() => {
		getTableWidthHeight();
	}, []);

	window.onresize = () => {
		getTableWidthHeight();
	};

	return (
		<div
			ref={virtuallyTableBoxRef}
			style={{ width: "100%", height: "100%", position: "relative" }}
		>
			<MyCircularProgress loading={loading} />
			{width && height && (
				<Table
					ref={virtuallyTableRef}
					width={width}
					height={height}
					headerHeight={59}
					rowHeight={54}
					rowCount={rows.length}
					rowGetter={({ index }: any) => rows[index]}
					headerClassName={style.VTHeader}
					rowClassName={({ index }: any) => {
						if (index < 0) {
							return style.VTHeaderRow;
						} else {
							return style.VTRow;
						}
					}}
				>
					{headCells.map((headCell) => {
						console.log(headCell.cellRenderer);
						return (
							<Column
								key={headCell.id}
								label={headCell.label}
								dataKey={headCell.id}
								width={headCell.width}
								flexGrow={headCell.flexGrow || 0}
								cellRenderer={
									headCell.cellRenderer
										? headCell.cellRenderer
										: (data: any) => {
												return data.cellData;
										  }
								}
								className={style.VTRowColumn}
							/>
						);
					})}
				</Table>
			)}
		</div>
	);
};

export default VirtuallyTable;
