import React from "react";
import classNames from "classnames";
import styles from "./index.module.css";
import "./label.css";
// import { Control, ValidationRules } from 'react-hook-form/dist/types/form';

export interface IHelpText {
	value: string /** 帮助文字内容 */;
	className?: string;
	type?: "normal" | "warning" /** 默认normal */;
}

export interface IFormItemBoxProps {
	/** label 标签的文本 */
	label?: string;
	/** 标签宽度 */
	labelWidth?: number;
	/** 标签文本对齐方式 */
	labelAlign?: "left" | "center" | "right";
	/** 标签文本的className */
	labelClassName?: string;
	/** 是否必填 */
	require?: boolean;
	/**  */
	children: React.ReactNode;
	className?: string;
	/** 最外层class */
	mainClass?: string;
	/** 校验信息 */
	errorMessage?: string;
	errorClassName?: string;
	itemFlex?: "row" | "column";
	/** 帮助文字提示信息 */
	helpText?: IHelpText;
}
const FormItemBox: React.FunctionComponent<IFormItemBoxProps> = (
	props: IFormItemBoxProps
) => {
	const {
		className,
		label,
		children,
		require,
		labelWidth,
		labelAlign,
		errorMessage,
		itemFlex,
		mainClass,
		helpText,
		labelClassName,
		errorClassName,
	} = props;

	return (
		<div
			className={classNames(
				styles.dynamicFormItem_div,
				mainClass,
				helpText && helpText.value && styles.dynamicFormItem_col_helpText
			)}
		>
			<div
				className={classNames(
					styles.dynamicFormItem_content,
					`dynamicFormItem-${itemFlex}`,
					className
				)}
			>
				<span
					style={{ width: `${labelWidth}px` }}
					className={classNames(
						styles.dynamicFormItem_label,
						{ [styles.is_require]: require },
						`align-${itemFlex === "row" ? labelAlign : "left"}`,
						labelClassName
					)}
				>
					{label}
				</span>
				<div className={styles.dynamicFormitem_child}>
					{children}
					{errorMessage && (
						<div
							className={classNames(
								styles.dynamicFormitem_errorTips,
								errorClassName
							)}
						>
							{errorMessage}
						</div>
					)}
					<div
						className={classNames(
							styles.dynamicFormitem_helpText,
							helpText &&
								helpText.type === "warning" &&
								styles.dynamicFormitem_helpText_warning,
							helpText && helpText.className
						)}
					>
						{helpText?.value}
					</div>
				</div>
			</div>
		</div>
	);
};
FormItemBox.defaultProps = {
	labelWidth: 100,
	labelAlign: "right",
	itemFlex: "row",
};
export default FormItemBox;
