import VirtuallyList from "@/components/CommonComponents/VirtuallyList";
import VirtuallyTable from "@/components/CommonComponents/VirtuallyTable";
import MyButton from "@/components/mui/MyButton";

const VirtuallyListDemo = () => {
	let listData: Array<any> = [];
	for (let i = 0; i < 10000; i++) {
		listData.push({
			name: "data" + i,
			id: "data" + i,
		});
	}
	const renderRow = ({
		index,
		isScrolling,
		isVisible,
		key,
		parent,
		style,
	}: any) => {
		return (
			<div key={key} style={style}>
				<div
					style={{
						display: "flex",
						justifyContent: "space-between",
						alignItems: "center",
					}}
				>
					<div>{listData[index].name}</div>
					<div>{listData[index].name}</div>
					<div>{listData[index].name}</div>
					<div>{listData[index].name}</div>
					<div>{listData[index].name}</div>
					<div>{listData[index].name}</div>
					<div>{listData[index].name}</div>
				</div>
			</div>
		);
	};

	const rows = [
		{
			a: "啊手动阀建行卡实际付款啦即使对方卢卡库上的飞机啊离开解放了；拉萨的飞机拉萨酱豆腐啊肌肤抵抗力就",
			b: "werewrw",
			c: "asdfasf",
			d: "asdfasdf",
			e: "asd4534",
			id: "1",
		},
	];
	for (let i = 0; i < 10000; i++) {
		rows.push({
			a: "xcgh",
			b: "sdf",
			c: "sdfg",
			d: "sdfg",
			e: "wertwe",
			id: "12" + i,
		});
	}
	const buttonHeadCells = [
		{
			id: "a",
			label: "属性a",
			width: 150,
		},
		{
			id: "b",
			label: "属性b",
			width: 150,
		},
		{
			id: "c",
			label: "属性c",
			width: 150,
			// flexGrow: 2,
		},
		{
			id: "d",
			label: "属性d",
			width: 200,
			flexGrow: 2,
		},
		{
			id: "caozuo",
			label: "操作",
			width: 150,
			cellRenderer: (data: any) => {
				return (
					<MyButton
						text="删除"
						onClick={() => {
							// handleDelete(row.id);
						}}
					></MyButton>
				);
			},
		},
	];

	return (
		<div>
			<div>
				{/* <VirtuallyList list={listData} renderRow={renderRow}></VirtuallyList>; */}
			</div>
			<div style={{ height: "600px" }}>
				<VirtuallyTable
					// rows={rows}
					rows={rows.map((row) => {
						return {
							...row,
							// caozuo: (
							// 	<MyButton
							// 		text="删除"
							// 		onClick={() => {
							// 			// handleDelete(row.id);
							// 		}}
							// 	></MyButton>
							// ),
						};
					})}
					headCells={buttonHeadCells}
				/>
			</div>
		</div>
	);
};

export default VirtuallyListDemo;
