import VirtuallyList from "@/components/CommonComponents/VirtuallyList";

const VirtuallyListDemo = () => {
	let listData: Array<any> = [];
	for (let i = 0; i < 10000; i++) {
		listData.push({
			name: "data" + i,
			id: "data" + i,
		});
	}
	const renderRow = ({
		index,
		isScrolling,
		isVisible,
		key,
		parent,
		style,
	}: any) => {
		return (
			<div key={key} style={style}>
				<div
					style={{
						display: "flex",
						justifyContent: "space-between",
						alignItems: "center",
						boxSizing: "border-box",
						height: "100%",
						border: "1px solid red",
					}}
				>
					<div>{listData[index].name}</div>
					<div>{listData[index].name}</div>
					<div>{listData[index].name}</div>
					<div>{listData[index].name}</div>
					<div>{listData[index].name}</div>
					<div>{listData[index].name}</div>
					<div>{listData[index].name}</div>
				</div>
			</div>
		);
	};

	return (
		<div>
			<div>
				<VirtuallyList
					list={listData}
					renderRow={renderRow}
					rowHeight={40}
				></VirtuallyList>
			</div>
		</div>
	);
};

export default VirtuallyListDemo;
