// 分子结构3D图
import { useEffect, useState } from "react";
import { Stage } from "ngl";
import { useMessage } from "@/components/MySnackbar";
import { Box } from "@mui/material";

type INglViewProps = {
	id: string;
	content: string; // 示例数据 contentDataMock  一般取后端返回的 pdb 字段
	width?: string;
	height?: string;
};

const NglView = (props: INglViewProps) => {
	const Message = useMessage();
	const { id, content, width = "100%", height = "100%" } = props;
	const [stage, setStage] = useState<any>(null);
	const [pdb, setPdb] = useState<any>(null);

	let firefox = navigator.userAgent.indexOf("FireFox") !== -1;
	// 鼠标滚动放大3d图的时候页面不会跟着滚动
	const MouseWheel = (e: any) => {
		e = e || window.event;
		// if (e.stopProagation) {
		// 	e.stopPropagation();
		// } else {
		// 	e.cancelBubble = true;
		// }
		if (e.preventDefault) {
			e.preventDefault();
		} else {
			e.returnValue = false;
		}
	};

	const resetStage = () => {
		if (stage) {
			stage.removeAllComponents();
			setStage(null);
		}
	};

	useEffect(() => {
		if (content) {
			let pdb = new Blob([content.trim()], { type: "text/plain" });
			if (pdb) {
				let contentBox = document.getElementById(id) as HTMLElement;
				if (contentBox) {
					contentBox.innerHTML = "";
				}
				firefox
					? contentBox?.addEventListener("DOMMouseScroll", MouseWheel, false)
					: (contentBox.onwheel = MouseWheel);
				resetStage();
				setStage(new Stage(id));
				setPdb(pdb);
			}
		}
		// eslint-disable-next-line react-hooks/exhaustive-deps
	}, [content]);

	useEffect(() => {
		try {
			stage &&
				stage.loadFile(pdb, {
					ext: "pdb",
					defaultRepresentation: true,
				});
		} catch (err) {
			console.log(err);
			Message.error("分子结构图渲染失败，请刷新重试。");
		}

		// eslint-disable-next-line react-hooks/exhaustive-deps
	}, [stage]);

	return <Box id={id} width={width} height={height}></Box>;
};

export default NglView;

// const contentDataMock = `REMARK VINA RESULT:    -6.039      0.000      0.000
// REMARK INTER + INTRA:          -7.654
// REMARK INTER:                  -7.995
// REMARK INTRA:                   0.341
// REMARK UNBOUND:                -0.203
// REMARK SMILES CN1C(=O)c2ccc(N3C(=O)c4ccc(Oc5ccc([N+](=O)[O-])cc5)cc4C3=O)cc2C1=O
// REMARK SMILES IDX 16 1 15 4 11 5 10 6 12 9 9 10 13 11 27 12 28 13 14 14 26 15
// REMARK SMILES IDX 29 16 8 19 7 20 30 21 6 22 31 23 5 24 32 25 3 26 33 27 2 28
// REMARK SMILES IDX 4 29 1 32 17 35 18 36 25 37 19 38 24 39 20 40 21 41 22 42
// REMARK SMILES IDX 23 43
// REMARK H PARENT
// REMARK Flexibility Score: inf
// COMPND    UNNAMED
// AUTHOR    GENERATED BY OPEN BABEL 3.1.0
// ATOM      1  O   LIG     1       6.958   5.187  16.199  1.00  0.00           O
// ATOM      2 WAT  LIG     1       7.927   4.962  13.368  1.00  0.00           W
// ATOM      3 WAT  LIG     1       6.361   7.884  17.368  1.00  0.00           W
// ATOM      4  C   LIG     1       8.006   4.700  16.965  1.00  0.00           C
// ATOM      5  O   LIG     1      11.909   3.392  19.972  1.00  0.00           O
// ATOM      6  C   LIG     1      10.833   2.980  19.589  1.00  0.00           C
// ATOM      7 WAT  LIG     1      13.514   1.792  21.938  1.00  0.00           W
// ATOM      8 WAT  LIG     1      12.959   6.013  18.958  1.00  0.00           W
// ATOM      9  C   LIG     1       9.994   3.706  18.630  1.00  0.00           C
// ATOM     10  N   LIG     1      10.171   1.809  19.872  1.00  0.00           N
// ATOM     11  C   LIG     1      10.225   4.905  17.988  1.00  0.00           C
// ATOM     12  C   LIG     1       8.832   2.986  18.430  1.00  0.00           C
// ATOM     13  C   LIG     1       8.954   1.750  19.224  1.00  0.00           C
// ATOM     14  C   LIG     1       9.212   5.403  17.165  1.00  0.00           C
// ATOM     15  C   LIG     1       7.811   3.462  17.610  1.00  0.00           C
// ATOM     16  O   LIG     1       8.080   0.907  19.285  1.00  0.00           O
// ATOM     17 WAT  LIG     1       8.484  -1.556  20.949  1.00  0.00           W
// ATOM     18 WAT  LIG     1       5.518   1.290  17.771  1.00  0.00           W
// ATOM     19  C   LIG     1      10.690   0.788  20.704  1.00  0.00           C
// ATOM     20  C   LIG     1      10.990   1.073  22.059  1.00  0.00           C
// ATOM     21  C   LIG     1      10.894  -0.512  20.209  1.00  0.00           C
// ATOM     22  C   LIG     1      11.467   0.078  22.930  1.00  0.00           C
// ATOM     23  C   LIG     1      11.413  -1.466  21.079  1.00  0.00           C
// ATOM     24  C   LIG     1      11.677  -1.183  22.406  1.00  0.00           C
// ATOM     25  C   LIG     1      11.784  -2.870  20.853  1.00  0.00           C
// ATOM     26  C   LIG     1      12.163  -2.413  23.041  1.00  0.00           C
// ATOM     27  O   LIG     1      11.755  -3.417  19.771  1.00  0.00           O
// ATOM     28  N   LIG     1      12.172  -3.374  22.066  1.00  0.00           N
// ATOM     29  O   LIG     1      12.481  -2.503  24.210  1.00  0.00           O
// ATOM     30 WAT  LIG     1      12.552  -6.299  19.526  1.00  0.00           W
// ATOM     31 WAT  LIG     1      10.885  -1.889  17.340  1.00  0.00           W
// ATOM     32  C   LIG     1      12.561  -4.748  22.299  1.00  0.00           C
// ATOM     33 WAT  LIG     1      13.453  -5.123  25.301  1.00  0.00           W
// ATOM     34 WAT  LIG     1      12.296  -0.106  26.005  1.00  0.00           W
// ATOM     35  C   LIG     1       5.741   4.530  16.202  1.00  0.00           C
// ATOM     36  C   LIG     1       5.748   3.131  16.178  1.00  0.00           C
// ATOM     37  C   LIG     1       4.519   5.215  16.142  1.00  0.00           C
// ATOM     38  C   LIG     1       4.542   2.418  16.098  1.00  0.00           C
// ATOM     39  C   LIG     1       3.309   4.512  16.150  1.00  0.00           C
// ATOM     40  C   LIG     1       3.324   3.112  16.136  1.00  0.00           C
// ATOM     41  N   LIG     1       2.059   2.366  16.222  1.00  0.00           N
// ATOM     42  O   LIG     1       1.977   1.297  15.600  1.00  0.00           O
// ATOM     43  O   LIG     1       1.160   2.836  16.934  1.00  0.00           O
// ATOM     44 WAT  LIG     1      -0.556  -0.307  15.704  1.00  0.00           W
// ATOM     45 WAT  LIG     1       4.310   0.313  13.991  1.00  0.00           W
// ATOM     46 WAT  LIG     1      -1.462   1.400  17.183  1.00  0.00           W
// ATOM     47 WAT  LIG     1       1.606   5.411  18.407  1.00  0.00           W
// CONECT    1   35    4
// CONECT    4    1   14   14   15
// CONECT    5    6    6
// CONECT    6    9   10    5    5
// CONECT    7   20
// CONECT    9   11   11   12    6
// CONECT   10   13    6   19
// CONECT   11   14    9    9
// CONECT   12   15   15    9   13
// CONECT   13   12   16   16   10
// CONECT   14    4    4   11
// CONECT   15    4   12   12
// CONECT   16   13   13
// CONECT   17   21
// CONECT   18   38
// CONECT   19   10   21   21   20
// CONECT   20   19    7   22   22
// CONECT   21   19   19   17   23
// CONECT   22   20   20   24
// CONECT   23   21   25   24   24
// CONECT   24   23   23   22   26
// CONECT   25   27   27   23   28
// CONECT   26   28   24   29   29
// CONECT   27   25   25
// CONECT   28   25   32   26
// CONECT   29   26   26
// CONECT   32   28
// CONECT   35   37   37   36    1
// CONECT   36   38   38   35
// CONECT   37   39   35   35
// CONECT   38   40   36   36   18
// CONECT   39   40   40   37
// CONECT   40   38   39   39   41
// CONECT   41   42   42   40   43
// CONECT   41   43
// CONECT   42   41   41
// CONECT   43   41   41
// CONECT   44   46   46   46
// CONECT   46   44   44   44
// MASTER        0    0    0    0    0    0    0    0   47    0   47    0`;
