/*
 * @Author: 吴永生 15770852798@163.com
 * @Date: 2022-07-11 11:56:58
 * @LastEditors: 吴永生 15770852798@163.com
 * @LastEditTime: 2022-08-02 17:40:14
 * @FilePath: /bkunyun/src/components/CommonComponents/RadioGroupOfButtonStyle/index.tsx
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
// 按钮样式的单选组
import classnames from "classnames";
import style from "./index.module.css";

type radioOption = {
	value: string;
	label: string;
};

type IRadioGroupOfButtonStyleProps = {
	radioOptions: Array<radioOption>;
	value: string;
	handleRadio: any;
	RadiosBoxStyle?: object;
	radioStyle?: object;
};

const RadioGroupOfButtonStyle = (props: IRadioGroupOfButtonStyleProps) => {
	const { radioOptions, value, handleRadio, RadiosBoxStyle, radioStyle } =
		props;

	return (
		<div className={style.RadiosBox} style={RadiosBoxStyle}>
			{radioOptions.map((options) => {
				return (
					<div
						key={options.value}
						className={classnames({
							[style.radio]: true,
							[style.radioActive]: value === options.value,
						})}
						onClick={() => handleRadio(options.value)}
						style={radioStyle}
					>
						{options.label}
					</div>
				);
			})}
		</div>
	);
};

export default RadioGroupOfButtonStyle;
