// 按钮样式的单选组
import classnames from "classnames";
import style from "./index.module.css";

type radioOption = {
	value: string;
	label: string;
};

type IRadioGroupOfButtonStyleProps = {
	radioOptions: Array<radioOption>;
	value: string;
	handleRadio: any;
	RadiosBoxStyle?: object;
	radioStyle?: object;
};

const RadioGroupOfButtonStyle = (props: IRadioGroupOfButtonStyleProps) => {
	const { radioOptions, value, handleRadio, RadiosBoxStyle, radioStyle } =
		props;

	return (
		<div className={style.RadiosBox} style={RadiosBoxStyle}>
			{radioOptions.map((options) => {
				return (
					<div
						key={options.value}
						className={classnames({
							[style.radio]: true,
							[style.radioActive]: value === options.value,
						})}
						onClick={() => handleRadio(options.value)}
						style={radioStyle}
					>
						{options.label}
					</div>
				);
			})}
		</div>
	);
};

export default RadioGroupOfButtonStyle;
