import React from 'react'
import { makeStyles,Grid, } from '@material-ui/core'
import Text from "@/commons/components/Material.Ui/Text"
import ArrowDropUpIcon from '@material-ui/icons/ArrowDropUp';
import SelectComponent from "@/commons/components/Material.Ui/Input"
import ArrowDropDownIcon from '@material-ui/icons/ArrowDropDown';
const style= makeStyles({
    flex:{
        minWidth:'74px',
        height:'32px',
        display:'flex',
        alignItems:'center',
        justifyContent:'space-evenly',
        border:'1px solid rgba(216, 216, 216, 0.6)'
    },
    icon:{
        height:'32px',
        display:'flex',
        flexDirection:'column',
        justifyContent:'space-around'
        // overflow:'hidden',
    },
    up:{
        height:'0',
        width:'0',
        cursor:'pointer',
        border:'5px solid transparent',
        borderBottomColor:'rgba(117, 117, 117, 1)'
    },
    down:{
        height:'0',
        width:'0',
        cursor:'pointer',
        border:'5px solid transparent',
        borderTopColor:'rgba(117, 117, 117, 1)'
    },
    handwareRightContentGrid2:{
        width:'74px',
        height:'32px',
    },
    customizationRoot:{
        height:'16px',
    }
})
let time = 0
let timer = null
let timer2 = null
let numCache = 0
let upCache = false
export default props => {
    const classes = style()
    const [num,setNum] = React.useState(72)
    const { change, current } = props
    const operation ={
        down:(up)=>{
            numCache = num
            time = 0
            upCache = up ? true : false
            window.addEventListener('mouseup',operation.up)
            timer = setTimeout( ()=>{ 
                time = 1
                operation.ldown(up)
            } ,500 )
        },
        up:()=>{
            window.removeEventListener('mouseup',operation.up)
            clearTimeout(timer)
            timer = null
            timer2 && clearTimeout(timer2)
            timer2 = null
            if(time === 0 && !(!upCache && numCache <= 0)) {
                setNum(upCache?numCache+1:numCache-1)
            } 
            timer = 0
        },
        ldown:(up)=>{
            timer2 && clearTimeout(timer2)
            if( !up && numCache <= 0 ) return
            numCache = up?(numCache+1):(numCache-1)
            setNum(numCache)
            timer2 = setTimeout(()=>{
                time = time+1
                operation.ldown(up)
            },time>10?100:200)
        },
        change:(e)=>{
            if( e.target.value.indexOf('-') > -1 ) return
                setNum(Number(e.target.value))
        }
    }
    React.useEffect(()=>{
        time = 0
        timer = null
        timer2 = null
        numCache = 0
        upCache = false
    },[])
    React.useEffect(()=>{
        ![undefined,''].includes(current) && setNum(current)
    },[current])
    React.useEffect(()=>{
        change && change( num )
    },[num])
    const typeInput = {
        icon: (type) => {
            return (
                <Grid className={classes.icon}>
                    <Grid className={classes.up} onMouseDown={()=>operation.down(1)}></Grid>
                    <Grid className={classes.down} onMouseDown={()=>operation.down()}></Grid>
                </Grid>
            )
        },
    }
    return (
        <Grid className={classes.handwareRightContentGrid2}>
          <SelectComponent
              size='xsmall'
              customClass = {classes.customizationRoot}
              fullWidth={true}
              textAlign={"right"}
              value={String(num)}
              endAdornment={typeInput.icon("cpu")}
              type={'number'}
              onChange={operation.change}
          />
        </Grid>)
}